/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.elasticsearch.configuration;

import cn.easyes.starter.register.EsMapperScan;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.data.elasticsearch.esearchx.EsContext;
import com.taotao.cloud.data.elasticsearch.properties.ElasticsearchProperties;
import com.taotao.cloud.data.elasticsearch.properties.RestClientPoolProperties;
import com.taotao.cloud.data.elasticsearch.service.IAggregationService;
import com.taotao.cloud.data.elasticsearch.service.IIndexService;
import com.taotao.cloud.data.elasticsearch.service.IQueryService;
import com.taotao.cloud.data.elasticsearch.service.impl.AggregationServiceImpl;
import com.taotao.cloud.data.elasticsearch.service.impl.IndexServiceImpl;
import com.taotao.cloud.data.elasticsearch.service.impl.QueryServiceImpl;
import org.elasticsearch.client.RestClientBuilder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.elasticsearch.RestClientBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchConfiguration;

@AutoConfiguration
@EnableConfigurationProperties(value={RestClientPoolProperties.class, ElasticsearchProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.data.elasticsearch", name={"enabled"}, havingValue="true")
@EsMapperScan(value="com.taotao.cloud.*.es.mapper")
public class ElasticsearchAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(ElasticsearchAutoConfiguration.class, (String)"taotao-cloud-starter-data-elasticsearch", (String[])new String[0]);
    }

    @Bean
    public RestClientBuilderCustomizer restClientBuilderCustomizer(RestClientPoolProperties poolProperties) {
        return builder -> this.setRequestConfig(builder, poolProperties);
    }

    @Bean
    public IQueryService queryService() {
        return new QueryServiceImpl();
    }

    @Bean
    public IAggregationService aggregationService() {
        return new AggregationServiceImpl();
    }

    @Bean
    public IIndexService indexService() {
        return new IndexServiceImpl();
    }

    @Bean
    public EsContext buildEsContext(@Autowired org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchProperties properties) {
        return new EsContext(properties.getUris(), properties.getUsername(), properties.getPassword());
    }

    private void setRequestConfig(RestClientBuilder builder, RestClientPoolProperties poolProperties) {
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            requestConfigBuilder.setConnectTimeout(poolProperties.getConnectTimeOut().intValue()).setSocketTimeout(poolProperties.getSocketTimeOut().intValue()).setConnectionRequestTimeout(poolProperties.getConnectionRequestTimeOut().intValue());
            return requestConfigBuilder;
        });
    }

    @Configuration
    public static class ElasticsearchConfig
    extends ElasticsearchConfiguration
    implements InitializingBean {
        @Autowired
        private org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchProperties properties;

        public void afterPropertiesSet() throws Exception {
            LogUtils.started(ElasticsearchConfig.class, (String)"taotao-cloud-starter-data-elasticsearch", (String[])new String[0]);
        }

        public ClientConfiguration clientConfiguration() {
            return ClientConfiguration.builder().connectedTo(this.properties.getUris().toString()).build();
        }
    }
}

