/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.elasticsearch.esearchx;

import com.taotao.cloud.data.elasticsearch.esearchx.EsCommand;
import com.taotao.cloud.data.elasticsearch.esearchx.EsContext;
import com.taotao.cloud.data.elasticsearch.esearchx.PriHttpTimeout;
import com.taotao.cloud.data.elasticsearch.esearchx.PriHttpUtils;
import com.taotao.cloud.data.elasticsearch.esearchx.PriUtils;
import com.taotao.cloud.data.elasticsearch.esearchx.exception.NoExistException;
import com.taotao.cloud.data.elasticsearch.esearchx.model.EsAggs;
import com.taotao.cloud.data.elasticsearch.esearchx.model.EsCondition;
import com.taotao.cloud.data.elasticsearch.esearchx.model.EsData;
import com.taotao.cloud.data.elasticsearch.esearchx.model.EsHighlight;
import com.taotao.cloud.data.elasticsearch.esearchx.model.EsSort;
import com.taotao.cloud.data.elasticsearch.esearchx.model.EsSource;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.noear.snack.ONode;
import org.noear.snack.core.Options;

public class EsQuery {
    private final EsContext context;
    private final String indiceName;
    private final boolean isStream;
    private ONode dslq;
    private ONode queryMatch;
    private ONode item;
    private Options options;
    private String _format;
    private static final int limit_max_hits = 10000;
    PriHttpTimeout timeout;

    protected EsQuery(EsContext context, String indiceName, boolean isStream) {
        this.context = context;
        this.indiceName = indiceName;
        this.isStream = isStream;
        this.options = Options.def();
    }

    private PriHttpUtils getHttp(String path) {
        return this.context.getHttp(path);
    }

    private ONode getDslq() {
        if (this.dslq == null) {
            this.dslq = PriUtils.newNode().asObject();
        }
        return this.dslq;
    }

    private ONode getQueryMatch() {
        if (this.queryMatch == null) {
            this.queryMatch = PriUtils.newNode().asObject();
        }
        return this.queryMatch;
    }

    private String getJson(ONode oNode) {
        return oNode.options(this.options).toJson();
    }

    public EsQuery options(Options options) {
        if (options != null) {
            this.options = options;
        }
        return this;
    }

    public EsQuery options(Consumer<Options> builder) {
        builder.accept(this.options);
        return this;
    }

    public EsQuery set(String field, Object value) {
        if (this.item == null) {
            this.item = PriUtils.newNode();
        }
        this.item.set(field, value);
        return this;
    }

    private String insertDo(ONode doc) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.timeout = this.timeout;
        cmd.method = "POST";
        cmd.dslType = "application/json";
        cmd.dsl = this.getJson(doc);
        cmd.path = String.format("/%s/_doc/", this.indiceName);
        return this.context.execAsBody(cmd);
    }

    private String upsertDo(String docId, ONode doc) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.timeout = this.timeout;
        cmd.method = "PUT";
        cmd.dslType = "application/json";
        cmd.dsl = this.getJson(doc);
        cmd.path = String.format("/%s/_doc/%s", this.indiceName, docId);
        return this.context.execAsBody(cmd);
    }

    public String insert() throws IOException {
        return this.insertDo(this.item);
    }

    public <T> String insert(T doc) throws IOException {
        if (doc instanceof ONode) {
            return this.insertDo((ONode)doc);
        }
        return this.insertDo(ONode.loadObj(doc, (Options)this.options));
    }

    public <T> String insertList(List<T> docs) throws IOException {
        StringBuilder docJson = new StringBuilder();
        String type = this.isStream ? "create" : "index";
        docs.forEach(doc -> {
            docJson.append(this.getJson(PriUtils.newNode().build(n -> n.getOrNew(type).asObject()))).append("\n");
            if (doc instanceof ONode) {
                docJson.append(this.getJson((ONode)doc)).append("\n");
            } else {
                docJson.append(this.getJson(ONode.loadObj((Object)doc, (Options)this.options))).append("\n");
            }
        });
        EsCommand cmd = new EsCommand();
        cmd.timeout = this.timeout;
        cmd.method = "POST";
        cmd.dslType = "application/x-ndjson";
        cmd.dsl = docJson.toString();
        cmd.path = this.context.getVersion() > 7 ? String.format("/%s/_bulk", this.indiceName) : String.format("/%s/_doc/_bulk", this.indiceName);
        String tmp = this.context.execAsBody(cmd);
        return tmp;
    }

    public String upsert(String docId) throws IOException {
        return this.upsertDo(docId, this.item);
    }

    public <T> String upsert(String docId, T doc) throws IOException {
        if (doc instanceof ONode) {
            return this.upsertDo(docId, (ONode)doc);
        }
        return this.upsertDo(docId, ONode.loadObj(doc, (Options)this.options));
    }

    public <T> String upsertList(Map<String, T> docs) throws IOException {
        StringBuilder docJson = new StringBuilder();
        String type = this.isStream ? "create" : "index";
        docs.forEach((docId, doc) -> {
            docJson.append(this.getJson(PriUtils.newNode().build(n -> n.getOrNew(type).set("_id", docId)))).append("\n");
            if (doc instanceof ONode) {
                docJson.append(this.getJson((ONode)doc)).append("\n");
            } else {
                docJson.append(this.getJson(ONode.loadObj((Object)doc, (Options)this.options))).append("\n");
            }
        });
        EsCommand cmd = new EsCommand();
        cmd.timeout = this.timeout;
        cmd.method = "POST";
        cmd.dslType = "application/x-ndjson";
        cmd.dsl = docJson.toString();
        cmd.path = this.context.getVersion() > 7 ? String.format("/%s/_bulk", this.indiceName) : String.format("/%s/_doc/_bulk", this.indiceName);
        String tmp = this.context.execAsBody(cmd);
        return tmp;
    }

    public EsQuery where(Consumer<EsCondition> condition) {
        ONode oNode1 = PriUtils.newNode();
        EsCondition c = new EsCondition(oNode1);
        condition.accept(c);
        this.getDslq().set("query", (Object)oNode1);
        return this;
    }

    public EsQuery sql(String sql, String format) {
        this._format = format;
        this.getDslq().set("query", (Object)sql);
        return this;
    }

    public EsQuery sql(String sql) {
        return this.sql(sql, "json");
    }

    public EsQuery limit(int start, int size) {
        this.getDslq().set("from", (Object)start);
        this.getDslq().set("size", (Object)size);
        if (size >= 10000 || start + size >= 10000) {
            this.getDslq().set("track_total_hits", (Object)"true");
        }
        return this;
    }

    public EsQuery limit(int size) {
        this.getDslq().set("size", (Object)size);
        if (size >= 10000) {
            this.getDslq().set("track_total_hits", (Object)"true");
        }
        return this;
    }

    public EsQuery orderBy(Consumer<EsSort> sort) {
        EsSort s = new EsSort(this.getDslq().getOrNew("sort").asArray());
        sort.accept(s);
        return this;
    }

    public EsQuery orderByAsc(String field) {
        this.getDslq().getOrNew("sort").addNew().getOrNew(field).set("order", (Object)"asc");
        return this;
    }

    public EsQuery orderByDesc(String field) {
        this.getDslq().getOrNew("sort").addNew().getOrNew(field).set("order", (Object)"desc");
        return this;
    }

    public EsQuery andByAsc(String field) {
        this.getDslq().getOrNew("sort").addNew().getOrNew(field).set("order", (Object)"asc");
        return this;
    }

    public EsQuery andByDesc(String field) {
        this.getDslq().getOrNew("sort").addNew().getOrNew(field).set("order", (Object)"desc");
        return this;
    }

    public EsQuery onAfter(Object ... values) {
        this.getDslq().getOrNew("search_after").addAll(Arrays.asList(values));
        return this;
    }

    public EsQuery minScore(Object value) {
        this.getDslq().getOrNew("min_score").val(value);
        return this;
    }

    public EsQuery aggs(Consumer<EsAggs> aggs) {
        EsAggs a = new EsAggs(this.getDslq().getOrNew("aggs"));
        aggs.accept(a);
        return this;
    }

    public EsQuery highlight(Consumer<EsHighlight> highlight) {
        EsHighlight h = new EsHighlight(this.getDslq().getOrNew("highlight"));
        highlight.accept(h);
        return this;
    }

    public EsQuery timeout(int timeoutSeconds) {
        if (timeoutSeconds > 0) {
            this.timeout = new PriHttpTimeout(timeoutSeconds);
        }
        return this;
    }

    public EsQuery timeout(int connectTimeoutSeconds, int writeTimeoutSeconds, int readTimeoutSeconds) {
        if (connectTimeoutSeconds > 0) {
            this.timeout = new PriHttpTimeout(connectTimeoutSeconds, writeTimeoutSeconds, readTimeoutSeconds);
        }
        return this;
    }

    public String select(String dsl) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.timeout = this.timeout;
        cmd.method = "POST";
        cmd.dslType = "application/json";
        cmd.dsl = dsl;
        cmd.path = PriUtils.isEmpty(this._format) ? String.format("/%s/_search", this.indiceName) : String.format("/_sql?format=%s", this._format);
        String json = this.context.execAsBody(cmd);
        return json;
    }

    public String selectJson() throws IOException {
        return this.selectJson(null);
    }

    public String selectJson(String fields) throws IOException {
        if (PriUtils.isNotEmpty(fields)) {
            EsSource s = new EsSource(this.getDslq().getOrNew("_source"));
            if (fields.startsWith("!")) {
                s.excludes(fields.substring(1).split(","));
            } else {
                s.includes(fields.split(","));
            }
        }
        return this.select(this.getJson(this.getDslq()));
    }

    public ONode selectNode() throws IOException {
        return ONode.loadStr((String)this.selectJson());
    }

    public ONode selectNode(String fields) throws IOException {
        return ONode.loadStr((String)this.selectJson(fields));
    }

    public ONode selectAggs() throws IOException {
        return this.selectNode().getOrNew("aggregations");
    }

    public ONode selectAggs(String fields) throws IOException {
        return this.selectNode(fields).getOrNew("aggregations");
    }

    public Map selectMap() throws IOException {
        return this.selectOne(Map.class);
    }

    public Map selectMap(String fields) throws IOException {
        return this.selectOne(Map.class, fields);
    }

    public List<Map> selectMapList() throws IOException {
        return this.selectList(Map.class).getList();
    }

    public List<Map> selectMapList(String fields) throws IOException {
        return this.selectList(Map.class, fields).getList();
    }

    public <T> T selectOne(Class<T> clz) throws IOException {
        return this.selectOne(clz, null);
    }

    public <T> T selectOne(Class<T> clz, String fields) throws IOException {
        this.limit(1);
        EsData<T> page = this.selectList(clz, fields);
        if (page.getListSize() > 0) {
            return page.getList().get(0);
        }
        return null;
    }

    public <T> EsData<T> selectList(Class<T> clz) throws IOException {
        return this.selectList(clz, null);
    }

    public <T> EsData<T> selectList(Class<T> clz, String fields) throws IOException {
        if (this.queryMatch != null) {
            if (this.queryMatch.count() > 1) {
                this.getDslq().getOrNew("query").set("multi_match", (Object)this.queryMatch);
            } else {
                this.getDslq().getOrNew("query").set("match", (Object)this.queryMatch);
            }
        }
        String json = this.selectJson(fields);
        ONode oHits = ONode.loadStr((String)json).get("hits");
        long total = oHits.get("total").get("value").getLong();
        double max_score = oHits.get("oHits").getDouble();
        oHits.get("hits").forEach(n -> n.setAll(n.get("_source")));
        List list = oHits.get("hits").toObjectList(clz);
        return new EsData(total, max_score, list);
    }

    public <T> List<T> selectByIds(Class<T> clz, List<String> docIds) throws IOException {
        try {
            ONode oNode = PriUtils.newNode();
            oNode.getOrNew("query").getOrNew("ids").getOrNew("values").addAll(docIds);
            String json = this.select(this.getJson(oNode));
            ONode oHits = ONode.loadStr((String)json).get("hits");
            oHits.get("hits").forEach(n -> n.setAll(n.get("_source")));
            return oHits.get("hits").toObjectList(clz);
        }
        catch (NoExistException e) {
            return null;
        }
    }

    public <T> T selectById(Class<T> clz, String docId) throws IOException {
        try {
            EsCommand cmd = new EsCommand();
            cmd.timeout = this.timeout;
            cmd.method = "GET";
            cmd.path = String.format("/%s/_doc/%s", this.indiceName, docId);
            String tmp = this.context.execAsBody(cmd);
            ONode oItem = ONode.loadStr((String)tmp);
            oItem.setAll(oItem.get("_source"));
            return (T)oItem.toObject(clz);
        }
        catch (NoExistException e) {
            return null;
        }
    }

    public String delete() throws IOException {
        if (this.queryMatch != null) {
            if (this.queryMatch.count() > 1) {
                this.getDslq().getOrNew("query").set("multi_match", (Object)this.queryMatch);
            } else {
                this.getDslq().getOrNew("query").set("match", (Object)this.queryMatch);
            }
        }
        EsCommand cmd = new EsCommand();
        cmd.timeout = this.timeout;
        cmd.method = "POST";
        cmd.dslType = "application/json";
        cmd.dsl = this.getJson(this.getDslq());
        cmd.path = String.format("/%s/_delete_by_query", this.indiceName);
        String tmp = this.context.execAsBody(cmd);
        return tmp;
    }

    public boolean deleteById(String docId) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.timeout = this.timeout;
        cmd.method = "DELETE";
        cmd.path = String.format("/%s/_doc/%s", this.indiceName, docId);
        try {
            this.context.execAsBody(cmd);
            return true;
        }
        catch (NoExistException e) {
            return true;
        }
    }
}

