/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.elasticsearch.service.impl;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taotao.cloud.common.model.PageResult;
import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.data.elasticsearch.model.IndexDto;
import com.taotao.cloud.data.elasticsearch.service.IIndexService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;

public class IndexServiceImpl
implements IIndexService {
    @Autowired(required=false)
    private ElasticsearchTemplate elasticsearchTemplate;
    private final ObjectMapper mapper = new ObjectMapper();
    private final RestHighLevelClient client = (RestHighLevelClient)ContextUtils.getBean(RestHighLevelClient.class, (boolean)true);

    @Override
    public boolean create(IndexDto indexDto) throws IOException {
        CreateIndexRequest request = new CreateIndexRequest(indexDto.getIndexName());
        request.settings(Settings.builder().put("index.number_of_shards", indexDto.getNumberOfShards().intValue()).put("index.number_of_replicas", indexDto.getNumberOfReplicas().intValue()));
        if (StrUtil.isNotEmpty((CharSequence)indexDto.getType()) && StrUtil.isNotEmpty((CharSequence)indexDto.getMappingsSource())) {
            request.mapping(indexDto.getType(), indexDto.getMappingsSource(), XContentType.JSON);
        }
        CreateIndexResponse response = this.client.indices().create(request, RequestOptions.DEFAULT);
        return response.isAcknowledged();
    }

    @Override
    public boolean delete(String indexName) throws IOException {
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        AcknowledgedResponse response = this.client.indices().delete(request, RequestOptions.DEFAULT);
        return response.isAcknowledged();
    }

    @Override
    public PageResult<HashMap<String, String>> list(String queryStr, String indices) throws IOException {
        Response response = this.client.getLowLevelClient().performRequest(new Request("GET", "/_cat/indices?h=health,status,index,docsCount,docsDeleted,storeSize&s=cds:desc&format=json&index=" + StrUtil.nullToEmpty((CharSequence)indices)));
        List listOfIndicesFromEs = null;
        if (response != null) {
            String rawBody = EntityUtils.toString((HttpEntity)response.getEntity());
            TypeReference<List<HashMap<String, String>>> typeRef = new TypeReference<List<HashMap<String, String>>>(){};
            listOfIndicesFromEs = (List)this.mapper.readValue(rawBody, (TypeReference)typeRef);
        }
        return PageResult.of((long)100L, (int)1, (int)10, (int)30, listOfIndicesFromEs);
    }

    private Double getKB(Long bytes) {
        if (bytes == null) {
            return 0.0;
        }
        return (double)bytes.longValue() / 1024.0;
    }

    @Override
    public Map<String, Object> show(String indexName) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        return result;
    }
}

