/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.elasticsearch.service.impl;

import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.common.model.PageResult;
import com.taotao.cloud.data.elasticsearch.model.LogicDelDto;
import com.taotao.cloud.data.elasticsearch.model.SearchDto;
import com.taotao.cloud.data.elasticsearch.service.IAggregationService;
import com.taotao.cloud.data.elasticsearch.service.IQueryService;
import com.taotao.cloud.data.elasticsearch.service.ISearchService;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryServiceImpl
implements IQueryService {
    @Autowired(required=false)
    private ISearchService searchService;
    @Resource
    private IAggregationService aggregationService;

    @Override
    public PageResult<String> strQuery(String indexName, SearchDto searchDto) throws IOException {
        return this.strQuery(indexName, searchDto, null);
    }

    @Override
    public PageResult<String> strQuery(String indexName, SearchDto searchDto, LogicDelDto logicDelDto) throws IOException {
        this.setLogicDelQueryStr(searchDto, logicDelDto);
        return this.searchService.strQuery(indexName, searchDto);
    }

    private void setLogicDelQueryStr(SearchDto searchDto, LogicDelDto logicDelDto) {
        if (logicDelDto != null && StrUtil.isNotEmpty((CharSequence)logicDelDto.getLogicDelField()) && StrUtil.isNotEmpty((CharSequence)logicDelDto.getLogicNotDelValue())) {
            String queryStr = searchDto.getQueryStr();
            String logicStr = logicDelDto.getLogicDelField() + ":" + logicDelDto.getLogicNotDelValue();
            String result = StrUtil.isNotEmpty((CharSequence)queryStr) ? "(" + queryStr + ") AND " + logicStr : logicStr;
            searchDto.setQueryStr(result);
        }
    }

    @Override
    public Map<String, Object> requestStatAgg(String indexName, String routing) throws IOException {
        return this.aggregationService.requestStatAgg(indexName, routing);
    }
}

