/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.elasticsearch.service.impl;

import com.taotao.cloud.common.model.PageResult;
import com.taotao.cloud.data.elasticsearch.builder.SearchBuilder;
import com.taotao.cloud.data.elasticsearch.model.SearchDto;
import com.taotao.cloud.data.elasticsearch.service.ISearchService;
import java.io.IOException;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;

public class SearchServiceImpl
implements ISearchService {
    private final ElasticsearchTemplate elasticsearchTemplate;

    public SearchServiceImpl(ElasticsearchTemplate elasticsearchTemplate) {
        this.elasticsearchTemplate = elasticsearchTemplate;
    }

    @Override
    public PageResult<String> strQuery(String indexName, SearchDto searchDto) throws IOException {
        return SearchBuilder.builder(this.elasticsearchTemplate, indexName).setStringQuery(searchDto.getQueryStr()).addSort(searchDto.getSortCol(), SortOrder.DESC).setIsHighlight(searchDto.getHighlighter()).getPage(searchDto.getPage(), searchDto.getLimit());
    }
}

