/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.elasticsearch.builder;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.common.model.PageResult;
import com.taotao.cloud.common.utils.common.JsonUtils;
import com.taotao.cloud.common.utils.context.ContextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;

public class SearchBuilder {
    private static final String HIGHLIGHTER_PRE_TAGS = "<mark>";
    private static final String HIGHLIGHTER_POST_TAGS = "</mark>";
    private SearchRequest searchRequest;
    private SearchSourceBuilder searchBuilder;
    private RestHighLevelClient client;

    private SearchBuilder(SearchRequest searchRequest, SearchSourceBuilder searchBuilder, RestHighLevelClient client) {
        this.searchRequest = searchRequest;
        this.searchBuilder = searchBuilder;
        this.client = client;
    }

    public static SearchBuilder builder(ElasticsearchRestTemplate elasticsearchTemplate, String indexName) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.source(searchSourceBuilder);
        RestHighLevelClient client = (RestHighLevelClient)ContextUtils.getBean(RestHighLevelClient.class, (boolean)true);
        return new SearchBuilder(searchRequest, searchSourceBuilder, client);
    }

    public static SearchBuilder builder(ElasticsearchRestTemplate elasticsearchTemplate) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.source(searchSourceBuilder);
        RestHighLevelClient client = (RestHighLevelClient)ContextUtils.getBean(RestHighLevelClient.class, (boolean)true);
        return new SearchBuilder(searchRequest, searchSourceBuilder, client);
    }

    public SearchBuilder setIndices(String ... indices) {
        if (ArrayUtil.isNotEmpty((Object[])indices)) {
            this.searchRequest.indices(indices);
        }
        return this;
    }

    public SearchBuilder setStringQuery(String queryStr) {
        Object queryBuilder = StrUtil.isNotEmpty((CharSequence)queryStr) ? QueryBuilders.queryStringQuery((String)queryStr) : QueryBuilders.matchAllQuery();
        this.searchBuilder.query((QueryBuilder)queryBuilder);
        return this;
    }

    public SearchBuilder setPage(Integer page, Integer limit) {
        if (page != null && limit != null) {
            this.searchBuilder.from((page - 1) * limit).size(limit.intValue());
        }
        return this;
    }

    public SearchBuilder addSort(String field, SortOrder order) {
        if (StrUtil.isNotEmpty((CharSequence)field) && order != null) {
            this.searchBuilder.sort(field, order);
        }
        return this;
    }

    public SearchBuilder setHighlight(String field, String preTags, String postTags) {
        if (StrUtil.isNotEmpty((CharSequence)field) && StrUtil.isNotEmpty((CharSequence)preTags) && StrUtil.isNotEmpty((CharSequence)postTags)) {
            HighlightBuilder highlightBuilder = new HighlightBuilder();
            ((HighlightBuilder)highlightBuilder.field(field).preTags(new String[]{preTags})).postTags(new String[]{postTags});
            this.searchBuilder.highlighter(highlightBuilder);
        }
        return this;
    }

    public SearchBuilder setIsHighlight(Boolean isHighlighter) {
        if (BooleanUtil.isTrue((Boolean)isHighlighter)) {
            this.setHighlight("*", HIGHLIGHTER_PRE_TAGS, HIGHLIGHTER_POST_TAGS);
        }
        return this;
    }

    public SearchBuilder setRouting(String ... routing) {
        if (ArrayUtil.isNotEmpty((Object[])routing)) {
            this.searchRequest.routing(routing);
        }
        return this;
    }

    public SearchResponse get() throws IOException {
        return this.client.search(this.searchRequest, RequestOptions.DEFAULT);
    }

    public List<String> getList() throws IOException {
        return this.getList(this.get().getHits());
    }

    public PageResult<String> getPage() throws IOException {
        return this.getPage(null, null);
    }

    public PageResult<String> getPage(Integer page, Integer limit) throws IOException {
        this.setPage(page, limit);
        SearchResponse response = this.get();
        SearchHits searchHits = response.getHits();
        TotalHits totalCnt = searchHits.getTotalHits();
        List<String> list = this.getList(searchHits);
        return null;
    }

    private List<String> getList(SearchHits searchHits) {
        ArrayList<String> list = new ArrayList<String>();
        if (searchHits != null) {
            searchHits.forEach(item -> {
                Map map = JsonUtils.toMap((Object)item.getSourceAsString());
                map.put("id", item.getId());
                Map highlightFields = item.getHighlightFields();
                if (highlightFields != null) {
                    this.populateHighLightedFields(map, highlightFields);
                }
                String str = JsonUtils.toJSONString((Object)map);
                list.add(str);
            });
        }
        return list;
    }

    private <T> void populateHighLightedFields(T result, Map<String, HighlightField> highlightFields) {
        for (HighlightField field : highlightFields.values()) {
            String name = field.getName();
            if (name.endsWith(".keyword")) continue;
        }
    }

    private String concat(Text[] texts) {
        StringBuilder sb = new StringBuilder();
        for (Text text : texts) {
            sb.append(text.toString());
        }
        return sb.toString();
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public void setSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
    }

    public SearchSourceBuilder getSearchBuilder() {
        return this.searchBuilder;
    }

    public void setSearchBuilder(SearchSourceBuilder searchBuilder) {
        this.searchBuilder = searchBuilder;
    }

    public RestHighLevelClient getClient() {
        return this.client;
    }

    public void setClient(RestHighLevelClient client) {
        this.client = client;
    }
}

