/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.elasticsearch.configuration;

import cn.easyes.starter.register.EsMapperScan;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.data.elasticsearch.esearchx.EsContext;
import com.taotao.cloud.data.elasticsearch.properties.ElasticsearchProperties;
import com.taotao.cloud.data.elasticsearch.properties.RestClientPoolProperties;
import com.taotao.cloud.data.elasticsearch.service.IAggregationService;
import com.taotao.cloud.data.elasticsearch.service.IIndexService;
import com.taotao.cloud.data.elasticsearch.service.IQueryService;
import com.taotao.cloud.data.elasticsearch.service.ISearchService;
import com.taotao.cloud.data.elasticsearch.service.impl.AggregationServiceImpl;
import com.taotao.cloud.data.elasticsearch.service.impl.IndexServiceImpl;
import com.taotao.cloud.data.elasticsearch.service.impl.QueryServiceImpl;
import com.taotao.cloud.data.elasticsearch.service.impl.SearchServiceImpl;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchRestClientProperties;
import org.springframework.boot.autoconfigure.elasticsearch.RestClientBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchConfiguration;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;

@AutoConfiguration
@EnableConfigurationProperties(value={RestClientPoolProperties.class, ElasticsearchProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.data.elasticsearch", name={"enabled"}, havingValue="true")
@EsMapperScan(value="com.taotao.cloud.*.es.mapper")
public class ElasticsearchAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(ElasticsearchAutoConfiguration.class, (String)"taotao-cloud-starter-data-elasticsearch", (String[])new String[0]);
    }

    @Bean
    public RestClientBuilderCustomizer restClientBuilderCustomizer(RestClientPoolProperties poolProperties) {
        return builder -> {
            this.setRequestConfig(builder, poolProperties);
            this.setHttpClientConfig(builder, poolProperties, null);
        };
    }

    @Bean
    @ConditionalOnBean(value={RestHighLevelClient.class})
    public ElasticsearchRestTemplate elasticsearchRestTemplate(RestHighLevelClient restHighLevelClient) {
        return new ElasticsearchRestTemplate(restHighLevelClient);
    }

    @Bean
    public IQueryService queryService() {
        return new QueryServiceImpl();
    }

    @Bean
    @ConditionalOnBean(value={ElasticsearchRestTemplate.class})
    public ISearchService searchService(ElasticsearchRestTemplate elasticsearchRestTemplate) {
        return new SearchServiceImpl(elasticsearchRestTemplate);
    }

    @Bean
    public IAggregationService aggregationService() {
        return new AggregationServiceImpl();
    }

    @Bean
    public IIndexService indexService() {
        return new IndexServiceImpl();
    }

    @Bean
    public EsContext buildEsContext(@Autowired org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchProperties properties) {
        return new EsContext(properties.getUris(), properties.getUsername(), properties.getPassword());
    }

    private void setRequestConfig(RestClientBuilder builder, RestClientPoolProperties poolProperties) {
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            requestConfigBuilder.setConnectTimeout(poolProperties.getConnectTimeOut().intValue()).setSocketTimeout(poolProperties.getSocketTimeOut().intValue()).setConnectionRequestTimeout(poolProperties.getConnectionRequestTimeOut().intValue());
            return requestConfigBuilder;
        });
    }

    private void setHttpClientConfig(RestClientBuilder builder, RestClientPoolProperties poolProperties, ElasticsearchRestClientProperties restProperties) {
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder.setMaxConnTotal(poolProperties.getMaxConnectNum().intValue()).setMaxConnPerRoute(poolProperties.getMaxConnectPerRoute().intValue());
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            return httpClientBuilder;
        });
    }

    @Configuration
    public static class ElasticsearchConfig
    extends ElasticsearchConfiguration
    implements InitializingBean {
        @Autowired
        private org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchProperties properties;

        public void afterPropertiesSet() throws Exception {
            LogUtils.started(ElasticsearchConfig.class, (String)"taotao-cloud-starter-data-elasticsearch", (String[])new String[0]);
        }

        public ClientConfiguration clientConfiguration() {
            return ClientConfiguration.builder().connectedTo(this.properties.getUris().toString()).build();
        }
    }
}

