/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.elasticsearch.service.impl;

import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.data.elasticsearch.model.AggItemVo;
import com.taotao.cloud.data.elasticsearch.service.IAggregationService;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.ParsedDateRange;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.Cardinality;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class AggregationServiceImpl
implements IAggregationService {
    @Override
    public Map<String, Object> requestStatAgg(String indexName, String routing) throws IOException {
        LocalDateTime currDt = LocalDateTime.now();
        LocalDate localDate = LocalDate.now();
        LocalDateTime curDateTime = LocalDateTime.now();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.source(searchSourceBuilder).routing(routing);
        LocalDateTime dateTime = currDt.withHour(0).withMinute(0).withSecond(0).withNano(0);
        searchSourceBuilder.aggregation((AggregationBuilder)((DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)"currDate").field("timestamp")).addRange(dateTime.atZone(ZoneId.systemDefault()), currDt.plusDays(1L).atZone(ZoneId.systemDefault())).subAggregation((AggregationBuilder)AggregationBuilders.cardinality((String)"uv").field("ip.keyword"))).aggregation((AggregationBuilder)((DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)"curr24Hour").field("timestamp")).addRange(dateTime.minusDays(1L).atZone(ZoneId.systemDefault()), currDt.atZone(ZoneId.systemDefault())).subAggregation((AggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"statDate").field("timestamp")).dateHistogramInterval(new DateHistogramInterval("90m")).format("yyyy-MM-dd HH:mm:ss")).timeZone(ZoneId.systemDefault())).minDocCount(0L).extendedBounds(new LongBounds(curDateTime.minusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), curDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")))).subAggregation((AggregationBuilder)AggregationBuilders.cardinality((String)"uv").field("ip.keyword")))).aggregation((AggregationBuilder)((DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)"currWeek").field("timestamp")).subAggregation((AggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"statWeek").field("timestamp")).dateHistogramInterval(DateHistogramInterval.DAY).format("yyyy-MM-dd")).timeZone(ZoneId.systemDefault())).minDocCount(0L).extendedBounds(new LongBounds(localDate.minusDays(6L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")))).subAggregation((AggregationBuilder)AggregationBuilders.cardinality((String)"uv").field("ip.keyword")))).aggregation((AggregationBuilder)((DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)"currMonth").field("timestamp")).addRange(dateTime.minusDays(30L).atZone(ZoneId.systemDefault()), currDt.atZone(ZoneId.systemDefault()))).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"browser").field("browser.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"operatingSystem").field("operatingSystem.keyword")).aggregation((AggregationBuilder)((DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)"currHour").field("timestamp")).addRange(dateTime.minusHours(1L).atZone(ZoneId.systemDefault()), currDt.atZone(ZoneId.systemDefault())).subAggregation((AggregationBuilder)AggregationBuilders.cardinality((String)"uv").field("ip.keyword"))).size(0);
        RestHighLevelClient client = (RestHighLevelClient)ContextUtils.getBean(RestHighLevelClient.class, (boolean)true);
        SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
        Aggregations aggregations = response.getAggregations();
        HashMap<String, Object> result = new HashMap<String, Object>(15);
        if (aggregations != null) {
            this.setCurrDate(result, aggregations);
            this.setCurr24Hour(result, aggregations);
            this.setCurrWeek(result, aggregations);
            this.setCurrMonth(result, aggregations);
            this.setTermsData(result, aggregations, "browser");
            this.setTermsData(result, aggregations, "operatingSystem");
            this.setCurrHour(result, aggregations);
        }
        return result;
    }

    private void setCurrDate(Map<String, Object> result, Aggregations aggregations) {
        ParsedDateRange currDate = (ParsedDateRange)aggregations.get("currDate");
        Range.Bucket bucket = (Range.Bucket)currDate.getBuckets().get(0);
        Cardinality cardinality = (Cardinality)bucket.getAggregations().get("uv");
        result.put("currDate_pv", bucket.getDocCount());
        result.put("currDate_uv", cardinality.getValue());
    }

    private void setCurr24Hour(Map<String, Object> result, Aggregations aggregations) {
        ParsedDateRange curr24Hour = (ParsedDateRange)aggregations.get("curr24Hour");
        Range.Bucket bucket = (Range.Bucket)curr24Hour.getBuckets().get(0);
        this.setStatDate(result, bucket.getAggregations());
    }

    private void setCurrWeek(Map<String, Object> result, Aggregations aggregations) {
        ParsedDateRange currWeek = (ParsedDateRange)aggregations.get("currWeek");
        Range.Bucket bucket = (Range.Bucket)currWeek.getBuckets().get(0);
        result.put("currWeek_pv", bucket.getDocCount());
        this.setStatWeek(result, bucket.getAggregations());
    }

    private void setCurrMonth(Map<String, Object> result, Aggregations aggregations) {
        ParsedDateRange currMonth = (ParsedDateRange)aggregations.get("currMonth");
        Range.Bucket bucket = (Range.Bucket)currMonth.getBuckets().get(0);
        result.put("currMonth_pv", bucket.getDocCount());
    }

    private void setTermsData(Map<String, Object> result, Aggregations aggregations, String key) {
        Terms terms = (Terms)aggregations.get(key);
        ArrayList<String> legendData = new ArrayList<String>();
        ArrayList<AggItemVo> datas = new ArrayList<AggItemVo>();
        for (Terms.Bucket bucket : terms.getBuckets()) {
            legendData.add((String)bucket.getKey());
            AggItemVo item = new AggItemVo();
            item.setName((String)bucket.getKey());
            item.setValue(bucket.getDocCount());
            datas.add(item);
        }
        result.put(key + "_legendData", legendData);
        result.put(key + "_datas", datas);
    }

    private void setStatWeek(Map<String, Object> result, Aggregations aggregations) {
        ParsedDateHistogram agg = (ParsedDateHistogram)aggregations.get("statWeek");
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<Long> uv = new ArrayList<Long>();
        ArrayList<Long> pv = new ArrayList<Long>();
        for (Histogram.Bucket bucket : agg.getBuckets()) {
            items.add(bucket.getKeyAsString());
            pv.add(bucket.getDocCount());
            Cardinality cardinality = (Cardinality)bucket.getAggregations().get("uv");
            uv.add(cardinality.getValue());
        }
        result.put("statWeek_items", items);
        result.put("statWeek_uv", uv);
        result.put("statWeek_pv", pv);
    }

    private void setCurrHour(Map<String, Object> result, Aggregations aggregations) {
        ParsedDateRange currDate = (ParsedDateRange)aggregations.get("currHour");
        Range.Bucket bucket = (Range.Bucket)currDate.getBuckets().get(0);
        Cardinality cardinality = (Cardinality)bucket.getAggregations().get("uv");
        result.put("currHour_uv", cardinality.getValue());
    }

    private void setStatDate(Map<String, Object> result, Aggregations aggregations) {
        ParsedDateHistogram agg = (ParsedDateHistogram)aggregations.get("statDate");
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<Long> uv = new ArrayList<Long>();
        ArrayList<Long> pv = new ArrayList<Long>();
        for (Histogram.Bucket bucket : agg.getBuckets()) {
            items.add(this.getTimeByDatetimeStr(bucket.getKeyAsString()));
            pv.add(bucket.getDocCount());
            Cardinality cardinality = (Cardinality)bucket.getAggregations().get("uv");
            uv.add(cardinality.getValue());
        }
        result.put("statDate_items", items);
        result.put("statDate_uv", uv);
        result.put("statDate_pv", pv);
    }

    private String getTimeByDatetimeStr(String datetimeStr) {
        if (StrUtil.isNotEmpty((CharSequence)datetimeStr)) {
            return datetimeStr.substring(5, 16);
        }
        return "";
    }
}

