/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.jpa.base.repository;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.Querydsl;
import org.springframework.data.jpa.repository.support.QuerydslJpaPredicateExecutor;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.support.PageableExecutionUtils;

public abstract class JpaSuperRepository<T, I extends Serializable>
extends SimpleJpaRepository<T, I> {
    protected final JPAQueryFactory jpaQueryFactory;
    protected final QuerydslJpaPredicateExecutor<T> jpaPredicateExecutor;
    protected final EntityManager em;
    private final EntityPath<T> path;
    protected final Querydsl querydsl;

    public JpaSuperRepository(Class<T> domainClass, EntityManager em) {
        super(domainClass, em);
        this.em = em;
        this.jpaPredicateExecutor = new QuerydslJpaPredicateExecutor(JpaEntityInformationSupport.getEntityInformation(domainClass, (EntityManager)em), em, (EntityPathResolver)SimpleEntityPathResolver.INSTANCE, this.getRepositoryMethodMetadata());
        this.jpaQueryFactory = new JPAQueryFactory(em);
        this.path = SimpleEntityPathResolver.INSTANCE.createPath(domainClass);
        this.querydsl = new Querydsl(em, new PathBuilder(this.path.getType(), this.path.getMetadata()));
    }

    public Page<T> findPageable(Predicate predicate, Pageable pageable, OrderSpecifier<?> ... orders) {
        JPAQuery countQuery = this.jpaQueryFactory.selectFrom(this.path);
        countQuery.where(predicate);
        JPQLQuery query = this.querydsl.applyPagination(pageable, (JPQLQuery)countQuery);
        query.orderBy(orders);
        return PageableExecutionUtils.getPage((List)query.fetch(), (Pageable)pageable, () -> countQuery.fetch().size());
    }

    public int count(Predicate predicate) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom(this.path).where(predicate)).fetch().size();
    }

    public Boolean exists(Predicate predicate) {
        return this.jpaPredicateExecutor.exists(predicate);
    }

    public List<T> fetch(Predicate predicate) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom(this.path).where(predicate)).fetch();
    }

    public T fetchOne(Predicate predicate) {
        return (T)((JPAQuery)this.jpaQueryFactory.selectFrom(this.path).where(predicate)).fetchOne();
    }

    public int fetchCount(Predicate predicate) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom(this.path).where(predicate)).fetch().size();
    }

    public List<?> find(Predicate predicate, Expression<?> expr, OrderSpecifier<?> ... o) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(expr).from(this.path)).where(predicate)).orderBy(o)).fetch();
    }
}

