/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.jpa.bean;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;

public class TenantConnectionProvider
implements MultiTenantConnectionProvider {
    private static final long serialVersionUID = -1166976596388409766L;
    private final transient DataSource dataSource;

    public TenantConnectionProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getAnyConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void releaseAnyConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public Connection getConnection(String tenantIdentifier) throws SQLException {
        Connection connection = this.getAnyConnection();
        connection.setCatalog(tenantIdentifier);
        connection.setSchema(tenantIdentifier);
        return connection;
    }

    public void releaseConnection(String tenantIdentifier, Connection connection) throws SQLException {
        connection.setSchema(tenantIdentifier);
        connection.setCatalog(tenantIdentifier);
        this.releaseAnyConnection(connection);
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return false;
    }

    public <T> T unwrap(Class<T> unwrapType) {
        return null;
    }
}

