/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.jpa.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.data.jpa.bean.AuditorBean;
import com.taotao.cloud.data.jpa.bean.TenantConnectionProvider;
import com.taotao.cloud.data.jpa.bean.TenantIdentifierResolver;
import com.taotao.cloud.data.jpa.listener.HibernateInspector;
import com.taotao.cloud.data.jpa.properties.HibernateProperties;
import com.taotao.cloud.data.jpa.properties.TenantProperties;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.SessionFactoryImpl;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;

@AutoConfiguration
@EnableJpaAuditing
@EnableJpaRepositories(basePackages={"com.taotao.cloud.*.biz.repository.inf"})
@EnableConfigurationProperties(value={TenantProperties.class, HibernateProperties.class, JpaProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.data.jpa", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class HibernateAutoConfiguration
implements InitializingBean {
    private final JpaProperties jpaProperties;
    private final HibernateProperties hibernateProperties;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(HibernateAutoConfiguration.class, (String)"taotao-cloud-starter-data-jpa", (String[])new String[0]);
    }

    public HibernateAutoConfiguration(JpaProperties jpaProperties, HibernateProperties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
        this.jpaProperties = jpaProperties;
    }

    @Bean
    public AuditorBean auditorBean() {
        return new AuditorBean();
    }

    @Bean
    public MultiTenantConnectionProvider tenantConnectionProvider(DataSource dataSource) {
        return new TenantConnectionProvider(dataSource);
    }

    @Bean
    public CurrentTenantIdentifierResolver tenantIdentifierResolver() {
        return new TenantIdentifierResolver();
    }

    @Bean
    JpaVendorAdapter jpaVendorAdapter() {
        HibernateJpaVendorAdapter hibernateJpaVendorAdapter = new HibernateJpaVendorAdapter();
        hibernateJpaVendorAdapter.setShowSql(this.hibernateProperties.isShowSql());
        hibernateJpaVendorAdapter.setGenerateDdl(this.hibernateProperties.isGenerateDdl());
        hibernateJpaVendorAdapter.setDatabase(this.hibernateProperties.getDatabase());
        return hibernateJpaVendorAdapter;
    }

    @Bean
    LocalContainerEntityManagerFactoryBean entityManagerFactory(DataSource dataSource, JpaVendorAdapter jpaVendorAdapter, MultiTenantConnectionProvider multiTenantConnectionProvider, CurrentTenantIdentifierResolver currentTenantIdentifierResolver) {
        HashMap<String, Object> newJpaProperties = new HashMap<String, Object>(this.jpaProperties.getProperties());
        newJpaProperties.put("hibernate.multiTenancy", this.hibernateProperties.getMultiTenancy());
        newJpaProperties.put("hibernate.format_sql", this.hibernateProperties.isFormatSql());
        newJpaProperties.put("hibernate.highlight_sql", this.hibernateProperties.isHighlightSql());
        newJpaProperties.put("hibernate.multi_tenant_connection_provider", multiTenantConnectionProvider);
        newJpaProperties.put("hibernate.tenant_identifier_resolver", currentTenantIdentifierResolver);
        newJpaProperties.put("hibernate.implicit_naming_strategy", this.hibernateProperties.getImplicitNamingStrategy());
        newJpaProperties.put("hibernate.physical_naming_strategy", this.hibernateProperties.getPhysicalNamingStrategy());
        newJpaProperties.put("hibernate.dialect", this.hibernateProperties.getDialect());
        newJpaProperties.put("hibernate.jdbc.time_zone", this.hibernateProperties.getTimeZone());
        newJpaProperties.put("hibernate.session_factory.statement_inspector", this.hibernateProperties.getStatementInspector());
        newJpaProperties.put("hibernate.session_factory.interceptor", this.hibernateProperties.getInterceptor());
        newJpaProperties.put("hibernate.hbm2ddl.auto", "update");
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactoryBean.setDataSource(dataSource);
        entityManagerFactoryBean.setJpaPropertyMap(newJpaProperties);
        entityManagerFactoryBean.setJpaVendorAdapter(jpaVendorAdapter);
        entityManagerFactoryBean.setPackagesToScan(new String[]{this.hibernateProperties.getPackages()});
        entityManagerFactoryBean.setPersistenceUnitName(this.hibernateProperties.getPersistenceUnitName());
        return entityManagerFactoryBean;
    }

    @Configuration
    public static class HibernateListener
    implements InitializingBean {
        @PersistenceUnit
        private EntityManagerFactory entityManagerFactory;

        public void afterPropertiesSet() throws Exception {
            LogUtils.started(HibernateListener.class, (String)"taotao-cloud-starter-data-jpa", (String[])new String[0]);
        }

        @PostConstruct
        public void registerListener() {
            if (this.entityManagerFactory != null) {
                SessionFactoryImpl sessionFactory = (SessionFactoryImpl)this.entityManagerFactory.unwrap(SessionFactoryImpl.class);
                EventListenerRegistry registry = (EventListenerRegistry)sessionFactory.getServiceRegistry().getService(EventListenerRegistry.class);
                HibernateInspector.SaveOrUpdateListener saveOrUpdateListener = new HibernateInspector.SaveOrUpdateListener();
                registry.getEventListenerGroup(EventType.SAVE_UPDATE).appendListener((Object)saveOrUpdateListener);
                registry.getEventListenerGroup(EventType.SAVE).appendListener((Object)saveOrUpdateListener);
                registry.getEventListenerGroup(EventType.UPDATE).appendListener((Object)saveOrUpdateListener);
                registry.getEventListenerGroup(EventType.PERSIST).appendListener((Object)new HibernateInspector.PersistEventListener());
                registry.getEventListenerGroup(EventType.REFRESH).appendListener((Object)new HibernateInspector.RefreshEventListener());
                registry.getEventListenerGroup(EventType.DELETE).appendListener((Object)new HibernateInspector.DeleteListener());
                registry.getEventListenerGroup(EventType.LOAD).appendListener((Object)new HibernateInspector.LoadListener());
            }
        }

        @Bean
        public HibernateDaoSupport hibernateDaoSupport() {
            StandardHibernateDaoSupport daoSupport = new StandardHibernateDaoSupport();
            daoSupport.setSessionFactory((SessionFactory)this.entityManagerFactory.unwrap(SessionFactoryImpl.class));
            return daoSupport;
        }

        public static class StandardHibernateDaoSupport
        extends HibernateDaoSupport {
        }
    }
}

