/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.jpa.listener;

import cn.hutool.db.sql.SqlFormatter;
import com.taotao.cloud.common.utils.common.JsonUtils;
import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.core.model.Collector;
import com.taotao.cloud.data.jpa.listener.SqlContextHolder;
import java.util.Map;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.event.internal.DefaultDeleteEventListener;
import org.hibernate.event.internal.DefaultLoadEventListener;
import org.hibernate.event.internal.DefaultPersistEventListener;
import org.hibernate.event.internal.DefaultRefreshEventListener;
import org.hibernate.event.internal.DefaultSaveOrUpdateEventListener;
import org.hibernate.event.spi.DeleteEvent;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.hibernate.resource.jdbc.spi.StatementInspector;

public class HibernateInspector
implements StatementInspector {
    private String sql;

    public String inspect(String sql) {
        this.sql = sql;
        LogUtils.info((String)SqlFormatter.format((String)sql), (Object[])new Object[0]);
        SqlContextHolder.setSql(sql);
        return sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public static class LoadListener
    extends DefaultLoadEventListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
            String sql = SqlContextHolder.getSql();
            String entityClassName = event.getEntityClassName();
            Object result = event.getResult();
            LogUtils.info((String)"Hibernate LoadListener entityName: {} sql: {}, result: {}", (Object[])new Object[]{entityClassName, sql, JsonUtils.toJSONString((Object)result)});
            Collector collector = (Collector)ContextUtils.getBean(Collector.class, (boolean)true);
            if (Objects.nonNull(collector)) {
                try {
                    String replace = StringUtils.nullToEmpty((CharSequence)sql).replace("\r", "").replace("\n", "");
                    collector.hook("taotao.cloud.monitor.jpa.load.sql.hook").run(replace, () -> {
                        try {
                            super.onLoad(event, loadType);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                finally {
                    SqlContextHolder.clear();
                }
            }
        }
    }

    public static class DeleteListener
    extends DefaultDeleteEventListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDelete(DeleteEvent event) throws HibernateException {
            String sql = SqlContextHolder.getSql();
            Object object = event.getObject();
            String entityName = event.getEntityName();
            LogUtils.info((String)"Hibernate DeleteListener entityName: {} sql: {} object:{}", (Object[])new Object[]{entityName, sql, JsonUtils.toJSONString((Object)object)});
            Collector collector = (Collector)ContextUtils.getBean(Collector.class, (boolean)true);
            if (Objects.nonNull(collector)) {
                try {
                    String replace = StringUtils.nullToEmpty((CharSequence)sql).replace("\r", "").replace("\n", "");
                    collector.hook("taotao.cloud.monitor.jpa.delete.sql.hook").run(replace, () -> {
                        try {
                            super.onDelete(event);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                finally {
                    SqlContextHolder.clear();
                }
            }
        }
    }

    public static class SaveOrUpdateListener
    extends DefaultSaveOrUpdateEventListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSaveOrUpdate(SaveOrUpdateEvent event) {
            Object object = event.getObject();
            String sql = SqlContextHolder.getSql();
            String entityName = event.getEntityName();
            LogUtils.info((String)"Hibernate SaveOrUpdateListener entityName: {} sql: {} object: {}", (Object[])new Object[]{entityName, sql, JsonUtils.toJSONString((Object)object)});
            Collector collector = (Collector)ContextUtils.getBean(Collector.class, (boolean)true);
            if (Objects.nonNull(collector)) {
                try {
                    String replace = StringUtils.nullToEmpty((CharSequence)SqlContextHolder.getSql()).replace("\r", "").replace("\n", "");
                    collector.hook("taotao.cloud.monitor.jpa.onSaveOrUpdate.sql.hook").run(replace, () -> {
                        try {
                            super.onSaveOrUpdate(event);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                finally {
                    SqlContextHolder.clear();
                }
            }
        }
    }

    public static class PersistEventListener
    extends DefaultPersistEventListener {
        public void onPersist(PersistEvent event) throws HibernateException {
            Object object = event.getObject();
            String sql = SqlContextHolder.getSql();
            String entityName = event.getEntityName();
            LogUtils.info((String)"Hibernate PersistEventListener entityName: {} sql: {} object: {}", (Object[])new Object[]{entityName, sql, JsonUtils.toJSONString((Object)object)});
            super.onPersist(event);
        }

        public void onPersist(PersistEvent event, Map createCache) throws HibernateException {
            Object object = event.getObject();
            String sql = SqlContextHolder.getSql();
            String entityName = event.getEntityName();
            LogUtils.info((String)"Hibernate PersistEventListener entityName: {} sql: {}  result: {} createCache: {}", (Object[])new Object[]{entityName, sql, JsonUtils.toJSONString((Object)object), createCache});
            super.onPersist(event, createCache);
        }
    }

    public static class RefreshEventListener
    extends DefaultRefreshEventListener {
        public void onRefresh(RefreshEvent event) throws HibernateException {
            Object object = event.getObject();
            String entityName = event.getEntityName();
            String sql = SqlContextHolder.getSql();
            LogUtils.info((String)"Hibernate RefreshEventListener entityName: {} sql: {} object: {}", (Object[])new Object[]{entityName, sql, JsonUtils.toJSONString((Object)object)});
            super.onRefresh(event);
        }

        public void onRefresh(RefreshEvent event, Map refreshedAlready) {
            Object object = event.getObject();
            String entityName = event.getEntityName();
            String sql = SqlContextHolder.getSql();
            LogUtils.info((String)"Hibernate RefreshEventListener entityName: {} sql: {} refreshedAlready: {} object: {}", (Object[])new Object[]{entityName, sql, refreshedAlready, JsonUtils.toJSONString((Object)object)});
            super.onRefresh(event, refreshedAlready);
        }
    }
}

