/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.jpa.tenancy;

import javax.sql.DataSource;
import org.hibernate.engine.jdbc.connections.spi.AbstractDataSourceBasedMultiTenantConnectionProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;

public class MultiTenancyConnectionProvider
extends AbstractDataSourceBasedMultiTenantConnectionProviderImpl {
    private static final Logger log = LoggerFactory.getLogger(MultiTenancyConnectionProvider.class);
    private final DataSource defaultDataSource;
    private final DataSourceLookup dataSourceLookup;

    public MultiTenancyConnectionProvider(DataSource dataSource, DataSourceLookup dataSourceLookup) {
        this.defaultDataSource = dataSource;
        this.dataSourceLookup = dataSourceLookup;
    }

    protected DataSource selectAnyDataSource() {
        log.debug("[Herodotus] |- Select any dataSource: " + this.defaultDataSource);
        return this.defaultDataSource;
    }

    protected DataSource selectDataSource(String tenantIdentifier) {
        DataSource dataSource = this.dataSourceLookup.getDataSource(tenantIdentifier);
        log.debug("[Herodotus] |- Select dataSource from [{}] : [{}]", (Object)tenantIdentifier, (Object)dataSource);
        return dataSource;
    }
}

