/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.cipher.interceptor;

import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.data.mybatisplus.cipher.annotation.Cipher;
import com.taotao.cloud.data.mybatisplus.cipher.annotation.Encrypted;
import com.taotao.cloud.data.mybatisplus.cipher.service.CryptService;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.apache.ibatis.executor.BaseExecutor;
import org.apache.ibatis.executor.CachingExecutor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class FieldEncryptInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldEncryptInterceptor.class);
    private final ThreadLocal<Map<Object, Map<Field, String>>> originalFieldMapLocal = ThreadLocal.withInitial(ConcurrentHashMap::new);
    private static final int EXECUTOR_PARAMETER_COUNT_4 = 4;
    private static final int MAPPED_STATEMENT_INDEX = 0;
    private static final int PARAMETER_INDEX = 1;
    private static final int ROW_BOUNDS_INDEX = 2;
    private static final int CACHE_KEY_INDEX = 4;
    private static final int BOUND_SQL_INDEX = 5;
    private static final String SELECT_KEY = "selectKey";
    private String sqlId = "";
    private static String CONSTANT_CIPHER_TEXT;
    private static final String CONSTANT_VALUE = "0.00";
    private static final List<String> CONSTANT_VALUES;
    private CryptService cryptService;
    private ConversionService conversionService;

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        boolean cache = Boolean.FALSE;
        MappedStatement ms = (MappedStatement)args[0];
        Cipher cipher = this.getEnableCipher(ms);
        Object parameter = args[1];
        Map<Object, Map<Field, String>> originalFieldMap = this.originalFieldMapLocal.get();
        if (ms.getId().startsWith(this.sqlId) && ms.getId().endsWith(SELECT_KEY)) {
            this.restore(parameter);
            originalFieldMap.clear();
        }
        if (Objects.isNull(cipher)) {
            return invocation.proceed();
        }
        SqlCommandType sqlCommandType = ms.getSqlCommandType();
        if (SqlCommandType.SELECT.equals((Object)sqlCommandType)) {
            cache = this.isCache(invocation);
        } else {
            this.updateParameters(cipher, ms, parameter);
        }
        Object object = invocation.proceed();
        if (!CollectionUtils.isEmpty(originalFieldMap)) {
            this.restore(parameter);
            originalFieldMap.clear();
        }
        if (!cache && SqlCommandType.SELECT.equals((Object)sqlCommandType)) {
            return this.decrypt(object);
        }
        return object;
    }

    private void updateParameters(Cipher cipher, MappedStatement ms, Object parameter) {
        this.sqlId = ms.getId();
        boolean decrypt = cipher.value().equals((Object)Cipher.CipherType.DECRYPT);
        if (!(parameter instanceof Map)) {
            this.encryptByAnnByList(Collections.singletonList(parameter), decrypt);
        } else {
            Map<String, Object> map = this.getParameterMap(parameter);
            map.forEach((k, v) -> {
                if (v instanceof Collection) {
                    this.encryptByAnnByList((List)v, decrypt);
                } else {
                    this.encryptByAnnByList(Collections.singletonList(v), decrypt);
                }
            });
        }
    }

    private Map<String, Object> getParameterMap(Object parameter) {
        HashSet hashCodeSet = new HashSet();
        return ((Map)parameter).entrySet().stream().filter(e -> Objects.nonNull(e.getValue())).filter(r -> {
            if (!hashCodeSet.contains(r.getValue().hashCode())) {
                hashCodeSet.add(r.getValue().hashCode());
                return true;
            }
            return false;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void restore(Object obz) {
        Map<Object, Map<Field, String>> originalFieldMap = this.originalFieldMapLocal.get();
        if (!(obz instanceof Map)) {
            Map<Field, String> ori = originalFieldMap.get(obz);
            if (Objects.nonNull(ori)) {
                ori.forEach((field, k) -> ReflectionUtils.setField((Field)field, (Object)obz, (Object)k));
            }
        } else {
            Map<String, Object> map = this.getParameterMap(obz);
            map.forEach((k, v) -> {
                if (v instanceof Collection) {
                    ((List)v).stream().filter(Objects::nonNull).forEach(obj -> {
                        Map ori = (Map)originalFieldMap.get(obj);
                        if (Objects.nonNull(ori)) {
                            ori.forEach((field, value) -> ReflectionUtils.setField((Field)field, (Object)obj, (Object)value));
                        }
                    });
                } else {
                    Map ori = (Map)originalFieldMap.get(v);
                    if (Objects.nonNull(ori)) {
                        ori.forEach((field, value) -> ReflectionUtils.setField((Field)field, (Object)v, (Object)value));
                    }
                }
            });
        }
    }

    private boolean isCache(Invocation invocation) throws IllegalAccessException {
        BaseExecutor baseExecutor;
        Field field;
        BoundSql bs;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        CacheKey cacheKey = null;
        if (args.length == 4) {
            bs = ms.getBoundSql(parameter);
        } else {
            cacheKey = (CacheKey)args[4];
            bs = (BoundSql)args[5];
        }
        Object executor = invocation.getTarget();
        if (executor instanceof CachingExecutor) {
            field = ReflectionUtils.findField(CachingExecutor.class, (String)"delegate");
            assert (field != null);
            field.setAccessible(true);
            baseExecutor = (Executor)field.get(executor);
        } else {
            baseExecutor = (BaseExecutor)invocation.getTarget();
        }
        if (Objects.isNull(cacheKey)) {
            cacheKey = baseExecutor.createCacheKey(ms, parameter, (RowBounds)args[2], bs);
        }
        field = ReflectionUtils.findField(BaseExecutor.class, (String)"localCache");
        assert (field != null);
        field.setAccessible(true);
        PerpetualCache localCache = (PerpetualCache)field.get(baseExecutor);
        return Objects.nonNull(localCache.getObject((Object)cacheKey));
    }

    private Object decrypt(Object object) {
        if (Objects.nonNull(object)) {
            if (object instanceof List) {
                this.encryptByAnnByList((List)object, true);
            } else {
                this.encryptByAnnByList(Collections.singletonList(object), true);
            }
        }
        return object;
    }

    private Cipher getEnableCipher(MappedStatement ms) {
        String namespace = ms.getId();
        String className = namespace.substring(0, namespace.lastIndexOf("."));
        String methodName = ms.getId().substring(ms.getId().lastIndexOf(".") + 1);
        try {
            Method[] mes;
            for (Method m : mes = Class.forName(className).getMethods()) {
                if (!m.getName().equals(methodName) || !m.isAnnotationPresent(Cipher.class)) continue;
                return m.getAnnotation(Cipher.class);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void encryptByAnnByList(List<Object> list, boolean decrypt) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set annotationFields = this.getFields(list.get(0)).stream().filter(field -> field.isAnnotationPresent(Encrypted.class)).collect(Collectors.toSet());
        List<String> strings = list.stream().flatMap(obj -> this.getFields(obj).stream().filter(annotationFields::contains).map(field -> this.getField((Field)field, obj))).filter(Objects::nonNull).map(Object::toString).toList();
        Map map = IntStream.range(0, strings.size()).mapToObj(i -> new Tuple(i, (String)strings.get(i))).collect(Collectors.groupingBy(t -> t.index / 1000)).values().stream().collect(HashMap::new, (a, b) -> a.putAll(this.batchCipher((List<Tuple>)b, decrypt)), HashMap::putAll);
        list.forEach(obj -> {
            HashMap fieldOriMap = new HashMap();
            this.getFields(obj).stream().filter(annotationFields::contains).forEach(field -> {
                Object value = this.getField((Field)field, obj);
                if (!decrypt) {
                    fieldOriMap.put(field, String.valueOf(value));
                }
                if (Objects.nonNull(value)) {
                    ReflectionUtils.setField((Field)field, (Object)obj, (Object)this.getConversionService().convert(map.get(value.toString()), field.getType()));
                }
            });
            if (!decrypt) {
                this.originalFieldMapLocal.get().put(obj, fieldOriMap);
            }
        });
    }

    private List<Field> getFields(Object obj) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = obj.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        return fieldList;
    }

    private Object getField(Field field, Object obj) {
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)obj);
    }

    private Map<String, String> batchCipher(List<Tuple> oriValues, boolean decrypt) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (decrypt) {
            List<String> result2 = oriValues.stream().filter(tuple -> {
                if (Objects.equals(tuple.value, CONSTANT_CIPHER_TEXT)) {
                    result.put(tuple.value, CONSTANT_VALUE);
                    return false;
                }
                return true;
            }).map(tuple -> tuple.value).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(result2)) {
                return result;
            }
            result.putAll(this.getCryptService().batchDecrypt(result2));
        } else {
            List<String> result2 = oriValues.stream().filter(tuple -> {
                if (CONSTANT_VALUES.contains(tuple.value)) {
                    result.put(tuple.value, CONSTANT_CIPHER_TEXT);
                    return false;
                }
                return true;
            }).map(tuple -> tuple.value).toList();
            if (CollectionUtils.isEmpty(result2)) {
                return result;
            }
            result.putAll(this.getCryptService().batchEncrypt(result2));
        }
        return result;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        CONSTANT_CIPHER_TEXT = properties.getProperty("CONSTANT_CIPHER_TEXT");
        if (!StringUtils.hasLength((String)CONSTANT_CIPHER_TEXT)) {
            CONSTANT_CIPHER_TEXT = "taotao-cloud";
        }
    }

    private CryptService getCryptService() {
        if (this.cryptService == null) {
            try {
                this.cryptService = (CryptService)ContextUtils.getBean(CryptService.class, (boolean)true);
            }
            catch (Exception e) {
                LOGGER.error("CryptService not found", (Throwable)e);
                throw new RuntimeException("CryptService not found");
            }
        }
        return this.cryptService;
    }

    private ConversionService getConversionService() {
        if (this.conversionService == null) {
            try {
                this.conversionService = ContextUtils.getTypeConverter();
            }
            catch (Exception e) {
                LOGGER.error("TypeConverter not found", (Throwable)e);
                throw new RuntimeException("TypeConverter not found");
            }
        }
        return this.conversionService;
    }

    static {
        CONSTANT_VALUES = Arrays.asList("0,", "0.0", CONSTANT_VALUE, "0.000");
    }

    static class Tuple {
        int index;
        String value;

        Tuple(int index, String value) {
            this.index = index;
            this.value = value;
        }
    }
}

