/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.configuration;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.IllegalSQLInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.data.mybatisplus.datascope.DataScopeInterceptor;
import com.taotao.cloud.data.mybatisplus.interceptor.MpInterceptor;
import com.taotao.cloud.data.mybatisplus.interceptor.SqlPaginationInnerInterceptor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class MpInterceptorConfiguration
implements InitializingBean {
    private static final Long MAX_LIMIT = 1000L;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(MpInterceptorConfiguration.class, (String)"taotao-cloud-starter-data-mybatis-plus", (String[])new String[0]);
    }

    @Bean
    public MpInterceptor paginationInnerInterceptor() {
        SqlPaginationInnerInterceptor paginationInterceptor = new SqlPaginationInnerInterceptor();
        paginationInterceptor.setMaxLimit(MAX_LIMIT);
        paginationInterceptor.setDbType(DbType.MYSQL);
        paginationInterceptor.setOverflow(true);
        paginationInterceptor.setOptimizeJoin(true);
        return new MpInterceptor((InnerInterceptor)paginationInterceptor, 120);
    }

    @Bean
    public MpInterceptor blockAttackInnerInterceptor() {
        return new MpInterceptor((InnerInterceptor)new BlockAttackInnerInterceptor(), 121);
    }

    @Bean
    public MpInterceptor illegalSqlInnerInterceptor() {
        return new MpInterceptor((InnerInterceptor)new IllegalSQLInnerInterceptor(), 125);
    }

    @Bean
    public MpInterceptor optimisticLockerInnerInterceptor() {
        return new MpInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor(), 128);
    }

    public MpInterceptor getTenantInnerInterceptor() {
        return null;
    }

    public MpInterceptor dataScopeInterceptor() {
        return new MpInterceptor(new DataScopeInterceptor());
    }
}

