/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.configuration;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.core.model.Collector;
import com.taotao.cloud.data.mybatisplus.configuration.TenantAutoConfiguration;
import com.taotao.cloud.data.mybatisplus.datascope.DataScopeInterceptor;
import com.taotao.cloud.data.mybatisplus.handler.objecthandler.AutoFieldMetaObjectHandler;
import com.taotao.cloud.data.mybatisplus.handler.typehandler.like.FullLikeTypeHandler;
import com.taotao.cloud.data.mybatisplus.handler.typehandler.like.LeftLikeTypeHandler;
import com.taotao.cloud.data.mybatisplus.handler.typehandler.like.RightLikeTypeHandler;
import com.taotao.cloud.data.mybatisplus.injector.MateSqlInjector;
import com.taotao.cloud.data.mybatisplus.interceptor.MpInterceptor;
import com.taotao.cloud.data.mybatisplus.interceptor.SqlCollectorInterceptor;
import com.taotao.cloud.data.mybatisplus.interceptor.SqlLogInterceptor;
import com.taotao.cloud.data.mybatisplus.properties.MybatisPlusAutoFillProperties;
import com.taotao.cloud.data.mybatisplus.properties.MybatisPlusProperties;
import com.taotao.cloud.data.mybatisplus.properties.TenantProperties;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.type.EnumTypeHandler;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@MapperScan(basePackages={"com.taotao.cloud.*.biz.mapper"})
@EnableTransactionManagement
@AutoConfiguration(after={TenantAutoConfiguration.class})
@EnableConfigurationProperties(value={MybatisPlusAutoFillProperties.class, MybatisPlusProperties.class, TenantProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.data.mybatis-plus", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MybatisPlusAutoConfiguration
implements InitializingBean {
    private final TenantProperties tenantProperties;
    private final MybatisPlusAutoFillProperties autoFillProperties;
    private final MybatisPlusProperties mybatisPlusProperties;
    @Autowired(required=false)
    private TenantLineInnerInterceptor tenantLineInnerInterceptor;

    public MybatisPlusAutoConfiguration(TenantProperties tenantProperties, MybatisPlusAutoFillProperties autoFillProperties, MybatisPlusProperties mybatisPlusProperties) {
        this.tenantProperties = tenantProperties;
        this.autoFillProperties = autoFillProperties;
        this.mybatisPlusProperties = mybatisPlusProperties;
    }

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(MybatisPlusAutoConfiguration.class, (String)"taotao-cloud-starter-data-mybatis-plus", (String[])new String[0]);
    }

    @Bean
    public ISqlInjector sqlInjector() {
        return new MateSqlInjector();
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.cloud.data.mybatis-plus", name={"sqlLogEnable"}, havingValue="true", matchIfMissing=true)
    public SqlLogInterceptor sqlLogInterceptor() {
        return new SqlLogInterceptor();
    }

    @Bean
    @ConditionalOnClass(name={"org.apache.ibatis.plugin.Interceptor"})
    @ConditionalOnProperty(prefix="taotao.cloud.data.mybatis-plus", name={"sqlCollectorEnable"}, havingValue="true")
    public SqlCollectorInterceptor sqlMybatisInterceptor(Collector collector) {
        return new SqlCollectorInterceptor(collector);
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor(List<MpInterceptor> interceptors) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptors.stream().sorted(Comparator.comparing(MpInterceptor::getSortNo)).map(MpInterceptor::getInnerInterceptor).forEach(arg_0 -> ((MybatisPlusInterceptor)interceptor).addInnerInterceptor(arg_0));
        return interceptor;
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.cloud.data.mybatis-plus.auto-fill", name={"enabled"}, havingValue="true")
    public AutoFieldMetaObjectHandler metaObjectHandler() {
        return new AutoFieldMetaObjectHandler(this.autoFillProperties);
    }

    @Bean
    public DatabaseIdProvider getDatabaseIdProvider() {
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties properties = new Properties();
        properties.setProperty("Oracle", DbType.ORACLE.getDb());
        properties.setProperty("MySQL", DbType.MYSQL.getDb());
        properties.setProperty("Microsoft SQL Server", DbType.SQL_SERVER.getDb());
        databaseIdProvider.setProperties(properties);
        return databaseIdProvider;
    }

    @Bean
    public ConfigurationCustomizer configurationCustomizer() {
        return configuration -> {
            configuration.setDefaultEnumTypeHandler(EnumTypeHandler.class);
            configuration.setLogPrefix("log.mybatis");
        };
    }

    @Bean
    public LeftLikeTypeHandler getLeftLikeTypeHandler() {
        return new LeftLikeTypeHandler();
    }

    @Bean
    public RightLikeTypeHandler getRightLikeTypeHandler() {
        return new RightLikeTypeHandler();
    }

    @Bean
    public FullLikeTypeHandler getFullLikeTypeHandler() {
        return new FullLikeTypeHandler();
    }

    public InnerInterceptor getTenantInnerInterceptor() {
        return null;
    }

    public DataScopeInterceptor getDataScopeInnerInterceptor() {
        return new DataScopeInterceptor();
    }
}

