/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.data.mybatisplus.configuration.MybatisPlusAutoConfiguration;
import com.taotao.cloud.data.mybatisplus.properties.TenantProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@AutoConfiguration(before={MybatisPlusAutoConfiguration.class})
@EnableConfigurationProperties(value={TenantProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.data.mybatis-plus.tenant", name={"enabled"}, havingValue="true")
public class TenantAutoConfiguration
implements InitializingBean {
    private final TenantProperties tenantProperties;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(TenantAutoConfiguration.class, (String)"taotao-cloud-starter-data-mybatis-plus", (String[])new String[0]);
    }

    public TenantAutoConfiguration(TenantProperties tenantProperties) {
        this.tenantProperties = tenantProperties;
    }
}

