/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.datascope;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.taotao.cloud.common.utils.common.SecurityUtils;
import com.taotao.cloud.data.mybatisplus.datascope.DataScope;
import com.taotao.cloud.data.mybatisplus.datascope.DataScopeTypeEnum;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataScopeInterceptor
implements InnerInterceptor {
    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        DataScope dataScope = this.findDataScope(parameter).orElse(null);
        if (dataScope == null) {
            return;
        }
        Object originalSql = boundSql.getSql();
        String scopeName = dataScope.getScopeName();
        String selfScopeName = dataScope.getSelfScopeName();
        Long userId = dataScope.getUserId() == null ? SecurityUtils.getUserId() : dataScope.getUserId();
        List orgIds = dataScope.getOrgIds();
        DataScopeTypeEnum dsType = DataScopeTypeEnum.SELF;
        if (CollectionUtil.isEmpty(orgIds)) {
            Map result = null;
            if (result == null) {
                return;
            }
            Integer type = (Integer)result.get("dsType");
            dsType = DataScopeTypeEnum.get(type);
            orgIds = (List)result.get("orgIds");
        }
        if (DataScopeTypeEnum.ALL.eq(dsType)) {
            return;
        }
        if (DataScopeTypeEnum.SELF.eq(dsType)) {
            originalSql = "select * from (" + (String)originalSql + ") temp_data_scope where temp_data_scope." + selfScopeName + " = " + userId;
        } else if (StrUtil.isNotBlank((CharSequence)scopeName) && CollUtil.isNotEmpty(orgIds)) {
            String join = CollectionUtil.join((Iterable)orgIds, (CharSequence)",");
            originalSql = "select * from (" + (String)originalSql + ") temp_data_scope where temp_data_scope." + scopeName + " in (" + join + ")";
        }
        PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBoundSql.sql((String)originalSql);
    }

    public void setProperties(Properties properties) {
    }

    private DataScope findDataScopeObject(Object parameterObj) {
        if (parameterObj instanceof DataScope) {
            return (DataScope)parameterObj;
        }
        if (parameterObj instanceof Map) {
            for (Object val : ((Map)parameterObj).values()) {
                if (!(val instanceof DataScope)) continue;
                return (DataScope)val;
            }
        }
        return null;
    }

    protected Optional<DataScope> findDataScope(Object parameterObj) {
        if (parameterObj == null) {
            return Optional.empty();
        }
        if (parameterObj instanceof DataScope) {
            return Optional.of((DataScope)parameterObj);
        }
        if (parameterObj instanceof Map) {
            for (Object val : ((Map)parameterObj).values()) {
                if (!(val instanceof DataScope)) continue;
                return Optional.of((DataScope)val);
            }
        }
        return Optional.empty();
    }
}

