/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.datascope.dataPermission.aop;

import com.taotao.cloud.data.mybatisplus.datascope.dataPermission.annotation.DataPermission;
import com.taotao.cloud.data.mybatisplus.datascope.dataPermission.aop.DataPermissionContextHolder;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.MethodClassKey;
import org.springframework.core.annotation.AnnotationUtils;

@DataPermission
public class DataPermissionAdvice
implements MethodInterceptor {
    static final DataPermission DATA_PERMISSION_NULL = DataPermissionAdvice.class.getAnnotation(DataPermission.class);
    private final Map<MethodClassKey, DataPermission> dataPermissionCache = new ConcurrentHashMap<MethodClassKey, DataPermission>();

    public Map<MethodClassKey, DataPermission> getDataPermissionCache() {
        return this.dataPermissionCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        DataPermission dataPermission = this.findAnnotation(methodInvocation);
        if (Objects.nonNull(dataPermission)) {
            DataPermissionContextHolder.add(dataPermission);
        }
        try {
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            if (Objects.nonNull(dataPermission)) {
                DataPermissionContextHolder.remove();
            }
        }
    }

    private DataPermission findAnnotation(MethodInvocation methodInvocation) {
        Object targetObject;
        Class<?> clazz;
        Method method = methodInvocation.getMethod();
        MethodClassKey methodClassKey = new MethodClassKey(method, clazz = Objects.nonNull(targetObject = methodInvocation.getThis()) ? targetObject.getClass() : method.getDeclaringClass());
        DataPermission dataPermission = this.dataPermissionCache.get(methodClassKey);
        if (Objects.nonNull(dataPermission)) {
            return dataPermission != DATA_PERMISSION_NULL ? dataPermission : null;
        }
        dataPermission = (DataPermission)AnnotationUtils.findAnnotation((Method)method, DataPermission.class);
        if (Objects.isNull(dataPermission)) {
            dataPermission = (DataPermission)AnnotationUtils.findAnnotation(clazz, DataPermission.class);
        }
        this.dataPermissionCache.put(methodClassKey, Objects.nonNull(dataPermission) ? dataPermission : DATA_PERMISSION_NULL);
        return dataPermission;
    }
}

