/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.datascope.dataPermission.dept.rule;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.taotao.cloud.data.mybatisplus.base.entity.MpSuperEntity;
import com.taotao.cloud.data.mybatisplus.datascope.dataPermission.dept.service.DeptDataPermissionFrameworkService;
import com.taotao.cloud.data.mybatisplus.datascope.dataPermission.rule.DataPermissionRule;
import com.taotao.cloud.data.mybatisplus.utils.MpUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;

public class DeptDataPermissionRule
implements DataPermissionRule {
    private static final String DEPT_COLUMN_NAME = "dept_id";
    private static final String USER_COLUMN_NAME = "user_id";
    static final Expression EXPRESSION_NULL = new NullValue();
    private final DeptDataPermissionFrameworkService deptDataPermissionService;
    private final Map<String, String> deptColumns = new HashMap<String, String>();
    private final Map<String, String> userColumns = new HashMap<String, String>();
    private final Set<String> TABLE_NAMES = new HashSet<String>();

    public DeptDataPermissionRule(DeptDataPermissionFrameworkService deptDataPermissionService) {
        this.deptDataPermissionService = deptDataPermissionService;
    }

    @Override
    public Set<String> getTableNames() {
        return this.TABLE_NAMES;
    }

    @Override
    public Expression getExpression(String tableName, Alias tableAlias) {
        return new OrExpression();
    }

    private Expression buildDeptExpression(String tableName, Alias tableAlias, Set<Long> deptIds) {
        String columnName = this.deptColumns.get(tableName);
        if (StrUtil.isEmpty((CharSequence)columnName)) {
            return null;
        }
        if (CollUtil.isEmpty(deptIds)) {
            return null;
        }
        return new InExpression((Expression)MpUtils.buildColumn(tableName, tableAlias, columnName), (ItemsList)new ExpressionList(deptIds.stream().map(LongValue::new).collect(Collectors.toList())));
    }

    private Expression buildUserExpression(String tableName, Alias tableAlias, Boolean self, Long userId) {
        if (Boolean.FALSE.equals(self)) {
            return null;
        }
        String columnName = this.userColumns.get(tableName);
        if (StrUtil.isEmpty((CharSequence)columnName)) {
            return null;
        }
        return new EqualsTo((Expression)MpUtils.buildColumn(tableName, tableAlias, columnName), (Expression)new LongValue(userId.longValue()));
    }

    public void addDeptColumn(Class<? extends MpSuperEntity> entityClass) {
        this.addDeptColumn(entityClass, DEPT_COLUMN_NAME);
    }

    public void addDeptColumn(Class<? extends MpSuperEntity> entityClass, String columnName) {
        String tableName = TableInfoHelper.getTableInfo(entityClass).getTableName();
        this.addDeptColumn(tableName, columnName);
    }

    public void addDeptColumn(String tableName, String columnName) {
        this.deptColumns.put(tableName, columnName);
        this.TABLE_NAMES.add(tableName);
    }

    public void addUserColumn(Class<? extends MpSuperEntity> entityClass) {
        this.addUserColumn(entityClass, USER_COLUMN_NAME);
    }

    public void addUserColumn(Class<? extends MpSuperEntity> entityClass, String columnName) {
        String tableName = TableInfoHelper.getTableInfo(entityClass).getTableName();
        this.addUserColumn(tableName, columnName);
    }

    public void addUserColumn(String tableName, String columnName) {
        this.userColumns.put(tableName, columnName);
        this.TABLE_NAMES.add(tableName);
    }
}

