/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.datascope.dataPermission.factory;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import com.taotao.cloud.data.mybatisplus.datascope.dataPermission.annotation.DataPermission;
import com.taotao.cloud.data.mybatisplus.datascope.dataPermission.aop.DataPermissionContextHolder;
import com.taotao.cloud.data.mybatisplus.datascope.dataPermission.factory.DataPermissionRuleFactory;
import com.taotao.cloud.data.mybatisplus.datascope.dataPermission.rule.DataPermissionRule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DataPermissionRuleFactoryImpl
implements DataPermissionRuleFactory {
    private final List<DataPermissionRule> rules;

    public DataPermissionRuleFactoryImpl(List<DataPermissionRule> rules) {
        this.rules = rules;
    }

    @Override
    public List<DataPermissionRule> getDataPermissionRule() {
        DataPermission dataPermission = DataPermissionContextHolder.get();
        if (CollUtil.isEmpty(this.rules)) {
            return Collections.emptyList();
        }
        if (Objects.isNull(dataPermission)) {
            return this.rules;
        }
        if (!dataPermission.enable()) {
            return Collections.emptyList();
        }
        if (ArrayUtil.isNotEmpty((Object[])dataPermission.includeRules())) {
            return this.rules.stream().filter(rule -> ArrayUtil.contains((Object[])dataPermission.includeRules(), rule.getClass())).collect(Collectors.toList());
        }
        if (ArrayUtil.isNotEmpty((Object[])dataPermission.excludeRules())) {
            return this.rules.stream().filter(rule -> !ArrayUtil.contains((Object[])dataPermission.excludeRules(), rule.getClass())).collect(Collectors.toList());
        }
        return this.rules;
    }
}

