/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.datascope.datascope.aspect;

import com.taotao.cloud.common.model.SecurityUser;
import com.taotao.cloud.common.utils.common.SecurityUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.data.mybatisplus.datascope.datascope.annotation.DataScope;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataScopeAspect {
    public static final String DATA_SCOPE_ALL = "1";
    public static final String DATA_SCOPE_CUSTOM = "2";
    public static final String DATA_SCOPE_DEPT = "3";
    public static final String DATA_SCOPE_DEPT_AND_CHILD = "4";
    public static final String DATA_SCOPE_SELF = "5";
    public static final String DATA_SCOPE = "dataScope";

    @Before(value="@annotation(controllerDataScope)")
    public void doBefore(JoinPoint point, DataScope controllerDataScope) throws Throwable {
        this.clearDataScope(point);
        this.handleDataScope(point, controllerDataScope);
    }

    protected void handleDataScope(JoinPoint joinPoint, DataScope controllerDataScope) {
        SecurityUser loginUser = SecurityUtils.getCurrentUserWithNull();
        if (StringUtils.isNotNull((Object)loginUser) && !loginUser.isAdmin()) {
            DataScopeAspect.dataScopeFilter(joinPoint, loginUser, controllerDataScope.deptAlias(), controllerDataScope.userAlias());
        }
    }

    public static void dataScopeFilter(JoinPoint joinPoint, SecurityUser user, String deptAlias, String userAlias) {
    }

    private void clearDataScope(JoinPoint joinPoint) {
    }
}

