/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.datascope.perm.handler;

import com.taotao.cloud.common.utils.aop.AopUtils;
import com.taotao.cloud.common.utils.common.SecurityUtils;
import com.taotao.cloud.data.mybatisplus.datascope.perm.NestedPermission;
import com.taotao.cloud.data.mybatisplus.datascope.perm.Permission;
import com.taotao.cloud.data.mybatisplus.datascope.perm.local.DataPermContextHolder;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataPermAspectHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(permission)||@within(permission)")
    public Object doAround(ProceedingJoinPoint pjp, Permission permission) throws Throwable {
        Object obj = null;
        Permission methodAnnotation = (Permission)AopUtils.getAnnotation((JoinPoint)pjp, Permission.class);
        if (Objects.nonNull(methodAnnotation)) {
            DataPermContextHolder.putPermission(methodAnnotation);
        } else {
            DataPermContextHolder.putPermission(permission);
        }
        DataPermContextHolder.putUserDetail(SecurityUtils.getCurrentUserWithNull());
        try {
            obj = pjp.proceed();
        }
        finally {
            DataPermContextHolder.clearUserAndPermission();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(nestedPermission)||@within(nestedPermission)")
    public Object doAround(ProceedingJoinPoint pjp, NestedPermission nestedPermission) throws Throwable {
        Object obj = null;
        NestedPermission methodAnnotation = (NestedPermission)AopUtils.getAnnotation((JoinPoint)pjp, NestedPermission.class);
        if (Objects.nonNull(methodAnnotation)) {
            DataPermContextHolder.putNestedPermission(methodAnnotation);
        } else {
            DataPermContextHolder.putNestedPermission(nestedPermission);
        }
        DataPermContextHolder.putUserDetail(SecurityUtils.getCurrentUserWithNull());
        try {
            obj = pjp.proceed();
        }
        finally {
            DataPermContextHolder.clearNestedPermission();
        }
        return obj;
    }
}

