/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.datascope.perm.local;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.taotao.cloud.common.model.SecurityUser;
import com.taotao.cloud.data.mybatisplus.datascope.perm.NestedPermission;
import com.taotao.cloud.data.mybatisplus.datascope.perm.Permission;
import java.util.Optional;

public class DataPermContextHolder {
    private static final ThreadLocal<Permission> PERMISSION_LOCAL = new TransmittableThreadLocal();
    private static final ThreadLocal<NestedPermission> NESTED_PERMISSION_LOCAL = new TransmittableThreadLocal();
    private static final ThreadLocal<SecurityUser> USER_DETAIL_LOCAL = new TransmittableThreadLocal();

    public static void putPermission(Permission permission) {
        PERMISSION_LOCAL.set(permission);
    }

    public static Permission getPermission() {
        return PERMISSION_LOCAL.get();
    }

    public static void putNestedPermission(NestedPermission nestedPermission) {
        NESTED_PERMISSION_LOCAL.set(nestedPermission);
    }

    public static NestedPermission getNestedPermission() {
        return NESTED_PERMISSION_LOCAL.get();
    }

    public static void putUserDetail(SecurityUser dataPerm) {
        USER_DETAIL_LOCAL.set(dataPerm);
    }

    public static Optional<SecurityUser> getUserDetail() {
        return Optional.ofNullable(USER_DETAIL_LOCAL.get());
    }

    public static void clearUserAndPermission() {
        USER_DETAIL_LOCAL.remove();
        PERMISSION_LOCAL.remove();
    }

    public static void clearNestedPermission() {
        NESTED_PERMISSION_LOCAL.remove();
    }
}

