/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.datascope.perm.scope;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.taotao.cloud.common.exception.BusinessException;
import com.taotao.cloud.common.model.SecurityUser;
import com.taotao.cloud.data.mybatisplus.datascope.perm.NestedPermission;
import com.taotao.cloud.data.mybatisplus.datascope.perm.Permission;
import com.taotao.cloud.data.mybatisplus.datascope.perm.code.DataScopeEnum;
import com.taotao.cloud.data.mybatisplus.datascope.perm.configuration.DataPermProperties;
import com.taotao.cloud.data.mybatisplus.datascope.perm.local.DataPermContextHolder;
import com.taotao.cloud.data.mybatisplus.datascope.perm.scope.DataPermScope;
import com.taotao.cloud.data.mybatisplus.datascope.perm.scope.DataPermScopeHandler;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.stereotype.Component;

@Component
public class DataScopeInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    public static final String CREATOR = "create_by";
    private final DataPermProperties dataPermProperties;
    private final DataPermScopeHandler dataPermScopeHandler;

    public DataScopeInterceptor(DataPermProperties dataPermProperties, DataPermScopeHandler dataPermScopeHandler) {
        this.dataPermProperties = dataPermProperties;
        this.dataPermScopeHandler = dataPermScopeHandler;
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (!this.dataPermProperties.isEnableDataPerm()) {
            return;
        }
        NestedPermission nestedPermission = DataPermContextHolder.getNestedPermission();
        if (Objects.nonNull(nestedPermission) && !nestedPermission.dataScope()) {
            return;
        }
        Permission permission = DataPermContextHolder.getPermission();
        if (Objects.isNull(permission) || !permission.dataScope()) {
            return;
        }
        boolean admin = DataPermContextHolder.getUserDetail().map(SecurityUser::getAdmin).orElseThrow(() -> {
            throw new BusinessException("\u7528\u6237\u672a\u767b\u5f55");
        });
        if (admin) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), ms.getId()));
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            this.setWhere((PlainSelect)selectBody);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectBody;
            List selectBodyList = setOperationList.getSelects();
            selectBodyList.forEach(s -> this.setWhere((PlainSelect)s));
        }
    }

    protected void setWhere(PlainSelect plainSelect) {
        Expression sqlSegment = this.dataScope(plainSelect.getWhere());
        if (null != sqlSegment) {
            plainSelect.setWhere(sqlSegment);
        }
    }

    protected Expression dataScope(Expression where) {
        Expression queryExpression;
        DataPermScope dataPermScope = this.dataPermScopeHandler.getDataPermScope();
        DataScopeEnum scopeType = dataPermScope.getScopeType();
        switch (scopeType) {
            case SELF: {
                queryExpression = this.selfScope();
                break;
            }
            case DEPT_SCOPE: {
                Expression deptScopeExpression = this.deptScope(dataPermScope.getDeptScopeIds());
                queryExpression = new OrExpression(deptScopeExpression, this.selfScope());
                break;
            }
            case USER_SCOPE: {
                queryExpression = this.userScope(dataPermScope.getUserScopeIds());
                break;
            }
            case DEPT_AND_USER_SCOPE: {
                queryExpression = this.deptAndUserScope(dataPermScope.getDeptScopeIds(), dataPermScope.getUserScopeIds());
                break;
            }
            case BELONG_DEPT: 
            case BELONG_DEPT_AND_SUB: {
                queryExpression = this.deptScope(dataPermScope.getDeptScopeIds());
                break;
            }
            case ALL_SCOPE: {
                return where;
            }
            default: {
                throw new BusinessException("\u4ee3\u7801\u6709\u95ee\u9898");
            }
        }
        return new AndExpression((Expression)new Parenthesis(queryExpression), where);
    }

    protected Expression selfScope() {
        Long userId = DataPermContextHolder.getUserDetail().map(SecurityUser::getUserId).orElseThrow(() -> {
            throw new BusinessException("\u7528\u6237\u672a\u767b\u5f55");
        });
        return new EqualsTo((Expression)new Column(CREATOR), (Expression)new LongValue(userId.longValue()));
    }

    protected Expression userScope(Set<Long> userScopeIds) {
        Long userId = DataPermContextHolder.getUserDetail().map(SecurityUser::getUserId).orElseThrow(() -> {
            throw new BusinessException("\u7528\u6237\u672a\u767b\u5f55");
        });
        List userExpressions = ((Set)Optional.ofNullable(userScopeIds).orElse(new HashSet())).stream().map(LongValue::new).collect(Collectors.toList());
        userExpressions.add(new LongValue(userId.longValue()));
        return new InExpression((Expression)new Column(CREATOR), (ItemsList)new ExpressionList(userExpressions));
    }

    protected Expression deptScope(Set<Long> deptIds) {
        DataPermProperties.DataPerm dataPerm = this.dataPermProperties.getDataPerm();
        PlainSelect plainSelect = new PlainSelect();
        SelectExpressionItem selectItem = new SelectExpressionItem();
        selectItem.setExpression((Expression)new Column(dataPerm.getQueryField()));
        plainSelect.addSelectItems(new SelectItem[]{selectItem});
        plainSelect.setDistinct(new Distinct());
        plainSelect.setFromItem((FromItem)new Table(dataPerm.getTable()));
        List deptExpressions = ((Set)Optional.ofNullable(deptIds).orElse(new HashSet())).stream().map(LongValue::new).collect(Collectors.toList());
        if (deptExpressions.size() == 0) {
            deptExpressions.add(null);
        }
        plainSelect.setWhere((Expression)new InExpression((Expression)new Column(dataPerm.getWhereField()), (ItemsList)new ExpressionList(deptExpressions)));
        SubSelect subSelect = new SubSelect();
        subSelect.setSelectBody((SelectBody)plainSelect);
        return new InExpression((Expression)new Column(CREATOR), (ItemsList)subSelect);
    }

    protected Expression deptAndUserScope(Set<Long> deptScopeIds, Set<Long> userScopeIds) {
        Expression deptScopeExpression = this.deptScope(deptScopeIds);
        Expression userScopeExpression = this.userScope(userScopeIds);
        return new OrExpression(deptScopeExpression, userScopeExpression);
    }
}

