/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.druid;

import com.alibaba.druid.DbType;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.FilterEventAdapter;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.util.StringUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import java.sql.SQLException;
import java.util.ArrayList;

public class SqlLogFilter
extends FilterEventAdapter {
    private static final SQLUtils.FormatOption FORMAT_OPTION = new SQLUtils.FormatOption(false, false);

    protected void statementExecuteBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteBatchBefore(StatementProxy statement) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteUpdateBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteQueryBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteAfter(StatementProxy statement, String sql, boolean firstResult) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteBatchAfter(StatementProxy statement, int[] result) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteQueryAfter(StatementProxy statement, String sql, ResultSetProxy resultSet) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteUpdateAfter(StatementProxy statement, String sql, int updateCount) {
        statement.setLastExecuteTimeNano();
    }

    public void statement_close(FilterChain chain, StatementProxy statement) throws SQLException {
        if (!LogUtils.isInfoEnabled()) {
            return;
        }
        String sql = statement.getBatchSql();
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return;
        }
        int parametersSize = statement.getParametersSize();
        ArrayList<Object> parameters = new ArrayList<Object>(parametersSize);
        for (int i = 0; i < parametersSize; ++i) {
            JdbcParameter jdbcParam = statement.getParameter(i);
            parameters.add(jdbcParam != null ? jdbcParam.getValue() : null);
        }
        String dbType = statement.getConnectionProxy().getDirectDataSource().getDbType();
        String formattedSql = SQLUtils.format((String)sql, (DbType)DbType.of((String)dbType), parameters, (SQLUtils.FormatOption)FORMAT_OPTION);
        SqlLogFilter.printSql(formattedSql, statement);
    }

    private static void printSql(String sql, StatementProxy statement) {
        String sqlLogger = "==============  Sql Start  ==============\nExecute SQL \uff1a{}\nExecute Time\uff1a{}\n==============  Sql  End   ==============\n";
        LogUtils.info((String)sqlLogger, (Object[])new Object[]{sql.trim(), statement.getLastExecuteTimeNano()});
    }
}

