/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.dynamic.config;

import com.baomidou.dynamic.datasource.provider.AbstractJdbcDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.taotao.cloud.data.mybatisplus.dynamic.properties.MybatisPlusDynamicDataSourceProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

public class JdbcDynamicDataSourceProvider
extends AbstractJdbcDataSourceProvider {
    private final DataSourceProperties properties;
    private final MybatisPlusDynamicDataSourceProperties dynamicDataSourceProperties;
    private final StringEncryptor stringEncryptor;

    public JdbcDynamicDataSourceProvider(StringEncryptor stringEncryptor, DataSourceProperties properties, MybatisPlusDynamicDataSourceProperties dynamicDataSourceProperties) {
        super(properties.getDriverClassName(), properties.getUrl(), properties.getUsername(), properties.getPassword());
        this.stringEncryptor = stringEncryptor;
        this.properties = properties;
        this.dynamicDataSourceProperties = dynamicDataSourceProperties;
    }

    protected Map<String, DataSourceProperty> executeStmt(Statement statement) throws SQLException {
        ResultSet rs = statement.executeQuery(this.dynamicDataSourceProperties.getQueryDsSql());
        HashMap<String, DataSourceProperty> map = new HashMap<String, DataSourceProperty>(8);
        while (rs.next()) {
            String name = rs.getString("name");
            String username = rs.getString("username");
            String password = rs.getString("password");
            String url = rs.getString("url");
            DataSourceProperty property = new DataSourceProperty();
            property.setUsername(username);
            property.setLazy(Boolean.valueOf(true));
            try {
                property.setPassword(this.stringEncryptor.decrypt(password));
            }
            catch (Exception e) {
                property.setPassword(password);
            }
            property.setUrl(url);
            map.put(name, property);
        }
        DataSourceProperty property = new DataSourceProperty();
        property.setUsername(this.properties.getUsername());
        property.setPassword(this.properties.getPassword());
        property.setUrl(this.properties.getUrl());
        property.setLazy(Boolean.valueOf(false));
        map.put("master", property);
        return map;
    }
}

