/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.interceptor;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.IllegalSQLInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.taotao.cloud.data.mybatisplus.interceptor.MpInterceptor;
import com.taotao.cloud.data.mybatisplus.interceptor.SqlPaginationInnerInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MpInterceptorConfiguration {
    private static final Long MAX_LIMIT = 1000L;

    @Bean
    public MpInterceptor paginationInnerInterceptor() {
        SqlPaginationInnerInterceptor paginationInterceptor = new SqlPaginationInnerInterceptor();
        paginationInterceptor.setMaxLimit(MAX_LIMIT);
        paginationInterceptor.setDbType(DbType.MYSQL);
        paginationInterceptor.setOverflow(true);
        paginationInterceptor.setOptimizeJoin(true);
        return new MpInterceptor((InnerInterceptor)paginationInterceptor, 120);
    }

    @Bean
    public MpInterceptor blockAttackInnerInterceptor() {
        return new MpInterceptor((InnerInterceptor)new BlockAttackInnerInterceptor(), 121);
    }

    @Bean
    public MpInterceptor illegalSqlInnerInterceptor() {
        return new MpInterceptor((InnerInterceptor)new IllegalSQLInnerInterceptor(), 125);
    }

    @Bean
    public MpInterceptor optimisticLockerInnerInterceptor() {
        return new MpInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor(), 128);
    }
}

