/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.l2cache;

import com.taotao.cloud.cache.caffeine.manager.CaffeineAutoCacheManager;
import com.taotao.cloud.common.utils.context.ContextUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;

public class CaffeineMybatisCache
implements Cache {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private static final Logger log = LoggerFactory.getLogger(CaffeineMybatisCache.class);
    private final String id;
    private final org.springframework.cache.Cache cache;
    private final AtomicInteger counter = new AtomicInteger(0);

    public CaffeineMybatisCache(String id) {
        this.id = id;
        Object obj = ContextUtils.getBean((String)"caffeineCacheManager", (boolean)true);
        if (Objects.isNull(obj)) {
            throw new RuntimeException("\u8bf7\u5f00\u542fcaffeineCacheManager");
        }
        CaffeineAutoCacheManager cacheManager = (CaffeineAutoCacheManager)obj;
        this.cache = cacheManager.getCache(this.id);
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object key, Object value) {
        this.cache.put((Object)key.toString(), value);
        this.counter.incrementAndGet();
        log.debug("CACHE - Put data into Mybatis Cache, with key: [{}]", key);
    }

    public Object getObject(Object key) {
        Cache.ValueWrapper obj = this.cache.get((Object)key.toString());
        log.debug("CACHE - Get data from Mybatis Cache, with key: [{}]", key);
        return obj;
    }

    public Object removeObject(Object key) {
        Cache.ValueWrapper obj = this.cache.get((Object)key.toString());
        this.cache.evict(key);
        this.counter.decrementAndGet();
        log.debug("CACHE - Remove data from Mybatis Cache, with key: [{}]", key);
        return obj;
    }

    public void clear() {
        this.cache.clear();
        log.debug("CACHE - Clear Mybatis Cache.");
    }

    public int getSize() {
        return this.counter.get();
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}

