/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.l2cache;

import com.taotao.cloud.cache.jetcache.enhance.JetCacheCreateCacheFactory;
import com.taotao.cloud.common.utils.context.ContextUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetcacheMybatisCache
implements Cache {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private static final Logger log = LoggerFactory.getLogger(JetcacheMybatisCache.class);
    private final String id;
    private final com.alicp.jetcache.Cache<Object, Object> cache;
    private final AtomicInteger counter = new AtomicInteger(0);

    public JetcacheMybatisCache(String id) {
        this.id = id;
        Object obj = ContextUtils.getBean((String)"jetCacheCacheManager", (boolean)true);
        if (Objects.isNull(obj)) {
            throw new RuntimeException("\u8bf7\u5f00\u542fjetCacheCacheManager");
        }
        JetCacheCreateCacheFactory jetCacheCreateCacheFactory = (JetCacheCreateCacheFactory)obj;
        this.cache = jetCacheCreateCacheFactory.create(this.id);
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object key, Object value) {
        this.cache.put(key, value);
        this.counter.incrementAndGet();
        log.debug("CACHE - Put data into Mybatis Cache, with key: [{}]", key);
    }

    public Object getObject(Object key) {
        Object obj = this.cache.get(key);
        log.debug("CACHE - Get data from Mybatis Cache, with key: [{}]", key);
        return obj;
    }

    public Object removeObject(Object key) {
        Boolean obj = this.cache.remove(key);
        this.counter.decrementAndGet();
        log.debug("CACHE - Remove data from Mybatis Cache, with key: [{}]", key);
        return obj;
    }

    public void clear() {
        this.cache.close();
        log.debug("CACHE - Clear Mybatis Cache.");
    }

    public int getSize() {
        return this.counter.get();
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}

