/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.pagehelper;

import com.github.pagehelper.PageInfo;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.data.mybatisplus.pagehelper.PageParam;
import com.taotao.cloud.data.mybatisplus.pagehelper.PagedList;
import com.taotao.cloud.data.mybatisplus.pagehelper.SQLFilter;
import java.io.Serializable;

public class PageHelperUtils
implements Serializable {
    private static final long serialVersionUID = 377943433889798799L;

    public static <T> PagedList<T> exportPagedList(PageParam<T> pageParam) {
        PagedList pl = new PagedList();
        int pageSize = pageParam.getPageSize();
        if (pageSize <= 0) {
            pageSize = 10;
        } else {
            pl.setPageSize(pageSize);
        }
        int pageNum = pageParam.getPageNum();
        pl.setPageNum(pageNum);
        String orderBy = pageParam.getOrderBy();
        if (StringUtils.isNotEmpty((CharSequence)orderBy)) {
            String orderBySql = SQLFilter.sqlInject(orderBy);
            pl.setOrderBy(orderBySql);
        }
        return pl;
    }

    public static <T> PagedList<T> toPageList(PageInfo<T> spage) {
        PagedList pagedList = new PagedList();
        pagedList.setPageSize(spage.getPageSize());
        pagedList.setPageNum(spage.getPageNum());
        pagedList.setRecordCount((int)spage.getTotal());
        pagedList.setData(spage.getList());
        pagedList.setPageCount(spage.getPages());
        return pagedList;
    }
}

