/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.pagehelper;

import com.taotao.cloud.common.utils.lang.ObjectUtils;
import java.io.Serializable;
import java.util.List;

public class PagedList<T>
implements Serializable {
    private static final long serialVersionUID = -1253790062865437768L;
    private int pageNum = 1;
    private List<T> data = null;
    private int pageCount = 0;
    private int recordCount = -1;
    private int pagingType = 0;
    private int pageSize;
    private String orderBy;

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize <= 0) {
            return;
        }
        this.pageSize = pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        if (pageCount <= 0) {
            return;
        }
        this.pageCount = pageCount;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
        this.calcPageCount();
    }

    private void calcPageCount() {
        if (this.recordCount < 0) {
            return;
        }
        int tmp = this.recordCount % this.getPageSize();
        int n = this.pageCount = tmp == 0 ? this.recordCount / this.getPageSize() : this.recordCount / this.getPageSize() + 1;
        if (this.pageNum > this.pageCount && this.pageCount != 0) {
            this.pageNum = this.pageCount;
        }
        this.pageNum = this.pageCount;
    }

    public void setData(List<T> data) {
        this.data = data;
        if (ObjectUtils.isNotEmpty(data) && this.recordCount == -1) {
            this.recordCount = data.size();
        }
    }

    public List<T> getData() {
        return this.data;
    }

    public int getPagingType() {
        return this.pagingType;
    }

    public void setPagingType(int pagingType) {
        this.pagingType = pagingType;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public String getOrderBy() {
        return this.orderBy;
    }
}

