/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.tenant;

import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.toolkit.PropertyMapper;
import com.taotao.cloud.data.mybatisplus.tenant.MultiTenantLineHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.ValueListExpression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class MultiTenantLineInnerInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private static final String SELECT = "SELECT";
    private MultiTenantLineHandler tenantLineHandler;

    public MultiTenantLineHandler getTenantLineHandler() {
        return this.tenantLineHandler;
    }

    public void setTenantLineHandler(MultiTenantLineHandler tenantLineHandler) {
        this.tenantLineHandler = tenantLineHandler;
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)ms.getId())) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), null));
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)ms.getId())) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.parserMulti(mpBs.sql(), null));
        }
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        this.processSelectBody(select.getSelectBody());
        List withItemsList = select.getWithItemsList();
        if (!CollectionUtils.isEmpty((Collection)withItemsList)) {
            withItemsList.forEach(this::processSelectBody);
        }
    }

    protected void processSelectBody(SelectBody selectBody) {
        if (selectBody == null) {
            return;
        }
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            this.processSelectBody(withItem.getSubSelect().getSelectBody());
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            List selectBodys = operationList.getSelects();
            if (CollectionUtils.isNotEmpty((Collection)selectBodys)) {
                selectBodys.forEach(this::processSelectBody);
            }
        }
    }

    protected void processInsert(Insert insert, int index, String sql, Object obj) {
        Select select;
        if (this.tenantLineHandler.ignoreTable(insert.getTable().getName())) {
            return;
        }
        List columns = insert.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns)) {
            return;
        }
        String tenantIdColumn = this.tenantLineHandler.getTenantIdColumn();
        if (columns.stream().map(Column::getColumnName).anyMatch(i -> i.equals(tenantIdColumn))) {
            return;
        }
        columns.add(new Column(this.tenantLineHandler.getTenantIdColumn()));
        List duplicateUpdateColumns = insert.getDuplicateUpdateExpressionList();
        if (CollectionUtils.isNotEmpty((Collection)duplicateUpdateColumns)) {
            EqualsTo equalsTo = new EqualsTo();
            equalsTo.setLeftExpression((Expression)new StringValue(this.tenantLineHandler.getTenantIdColumn()));
            equalsTo.setRightExpression(this.tenantLineHandler.getTenantId());
            duplicateUpdateColumns.add(equalsTo);
        }
        if ((select = insert.getSelect()) != null) {
            this.processInsertSelect(select.getSelectBody());
        } else if (insert.getItemsList() != null) {
            ItemsList itemsList = insert.getItemsList();
            if (itemsList instanceof MultiExpressionList) {
                ((MultiExpressionList)itemsList).getExpressionLists().forEach(el -> el.getExpressions().add(this.tenantLineHandler.getTenantId()));
            } else {
                ((ExpressionList)itemsList).getExpressions().add(this.tenantLineHandler.getTenantId());
            }
        } else {
            throw ExceptionUtils.mpe((String)"Failed to process multiple-table update, please exclude the tableName or statementId", (Object[])new Object[0]);
        }
    }

    protected void processUpdate(Update update, int index, String sql, Object obj) {
        Table table = update.getTable();
        if (this.tenantLineHandler.ignoreTable(table.getName())) {
            return;
        }
        Expression expression = this.andExpression(table, update.getWhere());
        if (expression == null) {
            return;
        }
        update.setWhere(expression);
    }

    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        if (this.tenantLineHandler.ignoreTable(delete.getTable().getName())) {
            return;
        }
        Expression expression = this.andExpression(delete.getTable(), delete.getWhere());
        if (expression == null) {
            return;
        }
        delete.setWhere(expression);
    }

    protected Expression andExpression(Table table, Expression where) {
        if (this.tenantLineHandler.getTenantId() == null) {
            return null;
        }
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)this.getAliasColumn(table));
        equalsTo.setRightExpression(this.tenantLineHandler.getTenantId());
        if (null != where) {
            if (where instanceof OrExpression) {
                return new AndExpression((Expression)equalsTo, (Expression)new Parenthesis(where));
            }
            return new AndExpression((Expression)equalsTo, where);
        }
        return equalsTo;
    }

    protected void processInsertSelect(SelectBody selectBody) {
        PlainSelect plainSelect = (PlainSelect)selectBody;
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            this.processPlainSelect(plainSelect);
            this.appendSelectItem(plainSelect.getSelectItems());
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            this.appendSelectItem(plainSelect.getSelectItems());
            this.processInsertSelect(subSelect.getSelectBody());
        }
    }

    protected void appendSelectItem(List<SelectItem> selectItems) {
        SelectItem item;
        if (CollectionUtils.isEmpty(selectItems)) {
            return;
        }
        if (selectItems.size() == 1 && ((item = selectItems.get(0)) instanceof AllColumns || item instanceof AllTableColumns)) {
            return;
        }
        selectItems.add((SelectItem)new SelectExpressionItem((Expression)new Column(this.tenantLineHandler.getTenantIdColumn())));
    }

    protected void processPlainSelect(PlainSelect plainSelect) {
        List joins;
        List selectItems;
        FromItem fromItem = plainSelect.getFromItem();
        Expression where = plainSelect.getWhere();
        this.processWhereSubSelect(where);
        if (fromItem instanceof Table) {
            Expression builderExpression;
            Table fromTable = (Table)fromItem;
            if (!this.tenantLineHandler.ignoreTable(fromTable.getName()) && (builderExpression = this.builderExpression(where, fromTable)) != null) {
                plainSelect.setWhere(builderExpression);
            }
        } else {
            this.processFromItem(fromItem);
        }
        if (CollectionUtils.isNotEmpty((Collection)(selectItems = plainSelect.getSelectItems()))) {
            selectItems.forEach(this::processSelectItem);
        }
        if (CollectionUtils.isNotEmpty((Collection)(joins = plainSelect.getJoins()))) {
            joins.forEach(j -> {
                this.processJoin((Join)j);
                this.processFromItem(j.getRightItem());
            });
        }
    }

    protected void processWhereSubSelect(Expression where) {
        if (where == null) {
            return;
        }
        if (where instanceof FromItem) {
            this.processFromItem((FromItem)where);
            return;
        }
        if (where.toString().indexOf(SELECT) > 0) {
            if (where instanceof BinaryExpression) {
                BinaryExpression expression = (BinaryExpression)where;
                this.processWhereSubSelect(expression.getLeftExpression());
                this.processWhereSubSelect(expression.getRightExpression());
            } else if (where instanceof InExpression) {
                InExpression expression = (InExpression)where;
                ItemsList itemsList = expression.getRightItemsList();
                if (itemsList instanceof SubSelect) {
                    this.processSelectBody(((SubSelect)itemsList).getSelectBody());
                }
            } else if (where instanceof ExistsExpression) {
                ExistsExpression expression = (ExistsExpression)where;
                this.processWhereSubSelect(expression.getRightExpression());
            } else if (where instanceof NotExpression) {
                NotExpression expression = (NotExpression)where;
                this.processWhereSubSelect(expression.getExpression());
            } else if (where instanceof Parenthesis) {
                Parenthesis expression = (Parenthesis)where;
                this.processWhereSubSelect(expression.getExpression());
            }
        }
    }

    protected void processSelectItem(SelectItem selectItem) {
        if (selectItem instanceof SelectExpressionItem) {
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
            if (selectExpressionItem.getExpression() instanceof SubSelect) {
                this.processSelectBody(((SubSelect)selectExpressionItem.getExpression()).getSelectBody());
            } else if (selectExpressionItem.getExpression() instanceof Function) {
                this.processFunction((Function)selectExpressionItem.getExpression());
            }
        }
    }

    protected void processFunction(Function function) {
        ExpressionList parameters = function.getParameters();
        if (parameters != null) {
            parameters.getExpressions().forEach(expression -> {
                if (expression instanceof SubSelect) {
                    this.processSelectBody(((SubSelect)expression).getSelectBody());
                } else if (expression instanceof Function) {
                    this.processFunction((Function)expression);
                }
            });
        }
    }

    protected void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoinList() != null) {
                subJoin.getJoinList().forEach(this::processJoin);
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (fromItem instanceof ValuesList) {
            this.logger.debug("Perform a subquery, if you do not give us feedback");
        } else if (fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    protected void processJoin(Join join) {
        FromItem fromItem = join.getRightItem();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            if (this.tenantLineHandler.ignoreTable(fromTable.getName())) {
                return;
            }
            Expression builderExpression = this.builderExpression(join.getOnExpression(), fromTable);
            if (builderExpression == null) {
                return;
            }
            join.setOnExpression(builderExpression);
        }
    }

    protected Expression builderExpression(Expression currentExpression, Table table) {
        ValueListExpression listExpression = this.tenantLineHandler.getTenantIdList();
        if (listExpression != null) {
            InExpression in = new InExpression();
            in.setLeftExpression((Expression)this.getAliasColumn(table));
            in.setRightExpression((Expression)listExpression);
            if (currentExpression == null) {
                return in;
            }
            if (currentExpression instanceof OrExpression) {
                return new AndExpression((Expression)new Parenthesis(currentExpression), (Expression)in);
            }
            return new AndExpression(currentExpression, (Expression)in);
        }
        Expression tenantId = this.tenantLineHandler.getTenantId();
        EqualsTo equalsTo = new EqualsTo();
        if (tenantId == null) {
            return null;
        }
        equalsTo.setLeftExpression((Expression)this.getAliasColumn(table));
        equalsTo.setRightExpression(this.tenantLineHandler.getTenantId());
        if (currentExpression == null) {
            return equalsTo;
        }
        if (currentExpression instanceof OrExpression) {
            return new AndExpression((Expression)new Parenthesis(currentExpression), (Expression)equalsTo);
        }
        return new AndExpression(currentExpression, (Expression)equalsTo);
    }

    protected Column getAliasColumn(Table table) {
        StringBuilder column = new StringBuilder();
        if (table.getAlias() != null) {
            column.append(table.getAlias().getName()).append(".");
        }
        column.append(this.tenantLineHandler.getTenantIdColumn());
        return new Column(column.toString());
    }

    public void setProperties(Properties properties) {
        PropertyMapper.newInstance((Properties)properties).whenNotBlank("tenantLineHandler", ClassUtils::newInstance, this::setTenantLineHandler);
    }
}

