/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.tenant;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.data.mybatisplus.utils.ReplaceSql;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class SchemaInterceptor
implements InnerInterceptor {
    private final String owner;
    private final String tenantDatabasePrefix;
    private final DbType dbType;

    public SchemaInterceptor(String tenantDatabasePrefix, String owner, DbType dbType) {
        this.tenantDatabasePrefix = tenantDatabasePrefix;
        this.owner = owner;
        this.dbType = dbType;
    }

    protected String changeTable(String sql) {
        Object schemaName = "";
        if (StrUtil.isNotEmpty((CharSequence)this.owner)) {
            schemaName = (String)schemaName + "." + this.owner;
        }
        return ReplaceSql.replaceSql(this.dbType, (String)schemaName, sql);
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE || sct == SqlCommandType.SELECT) {
            if (InterceptorIgnoreHelper.willIgnoreDynamicTableName((String)ms.getId())) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            LogUtils.debug((String)"\u672a\u66ff\u6362\u524d\u7684sql: {}", (Object[])new Object[]{mpBs.sql()});
            mpBs.sql(this.changeTable(mpBs.sql()));
        }
    }
}

