/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.data.mybatisplus.utils;

import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.taotao.cloud.common.utils.context.ContextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class MpUtils {
    private static final int BATCH_SIZE = 1000;
    private static final String MYSQL_ESCAPE_CHARACTER = "`";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, M, R> int batchUpdateOrInsert(List<T> data, Class<M> mapperClass, BiFunction<T, M, R> function) {
        int i = 1;
        SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)ContextUtils.getBean(SqlSessionFactory.class, (boolean)true);
        if (Objects.isNull(sqlSessionFactory)) {
            throw new MybatisPlusException("\u672a\u83b7\u53d6\u5230sqlSession");
        }
        try (SqlSession sqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH);){
            Object mapper = sqlSession.getMapper(mapperClass);
            int size = data.size();
            for (T element : data) {
                function.apply(element, mapper);
                if (i % 1000 == 0 || i == size) {
                    sqlSession.flushStatements();
                }
                ++i;
            }
        }
        return i - 1;
    }

    public static void addInterceptor(MybatisPlusInterceptor interceptor, InnerInterceptor inner, int index) {
        ArrayList<InnerInterceptor> inners = new ArrayList<InnerInterceptor>(interceptor.getInterceptors());
        inners.add(index, inner);
        interceptor.setInterceptors(inners);
    }

    public static String getTableName(Table table) {
        String tableName = table.getName();
        if (tableName.startsWith(MYSQL_ESCAPE_CHARACTER) && tableName.endsWith(MYSQL_ESCAPE_CHARACTER)) {
            tableName = tableName.substring(1, tableName.length() - 1);
        }
        return tableName;
    }

    public static Column buildColumn(String tableName, Alias tableAlias, String column) {
        return new Column((String)(tableAlias != null ? tableAlias.getName() + "." + column : column));
    }
}

