/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dingtalk.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.dingtalk.multi.MultiDingerAlgorithmInjectRegister;
import com.taotao.cloud.dingtalk.support.CustomMessage;
import com.taotao.cloud.dingtalk.support.DefaultDingerAsyncCallable;
import com.taotao.cloud.dingtalk.support.DefaultDingerExceptionCallback;
import com.taotao.cloud.dingtalk.support.DefaultDingerIdGenerator;
import com.taotao.cloud.dingtalk.support.DingTalkSignAlgorithm;
import com.taotao.cloud.dingtalk.support.DingerAsyncCallback;
import com.taotao.cloud.dingtalk.support.DingerExceptionCallback;
import com.taotao.cloud.dingtalk.support.DingerIdGenerator;
import com.taotao.cloud.dingtalk.support.MarkDownMessage;
import com.taotao.cloud.dingtalk.support.TextMessage;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnProperty(prefix="taotao.cloud.dinger", value={"enabled"}, havingValue="true")
public class BeanAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(BeanAutoConfiguration.class, (String)"taotao-cloud-starter-dingtalk", (String[])new String[0]);
    }

    @Bean(name={"textMessage"})
    @ConditionalOnMissingBean(name={"textMessage"})
    public CustomMessage textMessage() {
        return new TextMessage();
    }

    @Bean(name={"markDownMessage"})
    @ConditionalOnMissingBean(name={"markDownMessage"})
    public CustomMessage markDownMessage() {
        return new MarkDownMessage();
    }

    @Bean
    public DingTalkSignAlgorithm dingerSignAlgorithm() {
        return new DingTalkSignAlgorithm();
    }

    @Bean
    public DingerIdGenerator dingerIdGenerator() {
        return new DefaultDingerIdGenerator();
    }

    @Bean
    public DingerAsyncCallback dingerAsyncCallback() {
        return new DefaultDingerAsyncCallable();
    }

    @Bean
    public DingerExceptionCallback dingerExceptionCallback() {
        return new DefaultDingerExceptionCallback();
    }

    @Bean
    public MultiDingerAlgorithmInjectRegister multiDingerAlgorithmInjectRegister() {
        return new MultiDingerAlgorithmInjectRegister();
    }
}

