/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dingtalk.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.dingtalk.configuration.BeanAutoConfiguration;
import com.taotao.cloud.dingtalk.configuration.HttpClientAutoConfiguration;
import com.taotao.cloud.dingtalk.configuration.ThreadPoolAutoConfiguration;
import com.taotao.cloud.dingtalk.exception.ConfigurationException;
import com.taotao.cloud.dingtalk.model.DingerConfigurerAdapter;
import com.taotao.cloud.dingtalk.model.DingerManagerBuilder;
import com.taotao.cloud.dingtalk.model.DingerRobot;
import com.taotao.cloud.dingtalk.model.DingerSender;
import com.taotao.cloud.dingtalk.properties.DingerProperties;
import com.taotao.cloud.dingtalk.session.DingerSessionFactory;
import com.taotao.cloud.dingtalk.session.SessionConfiguration;
import com.taotao.cloud.dingtalk.spring.DingerSessionFactoryBean;
import com.taotao.cloud.dingtalk.support.CustomMessage;
import com.taotao.cloud.dingtalk.support.DingTalkSignAlgorithm;
import com.taotao.cloud.dingtalk.support.DingerAsyncCallback;
import com.taotao.cloud.dingtalk.support.DingerExceptionCallback;
import com.taotao.cloud.dingtalk.support.DingerHttpClient;
import com.taotao.cloud.dingtalk.support.DingerIdGenerator;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration(after={BeanAutoConfiguration.class, HttpClientAutoConfiguration.class, ThreadPoolAutoConfiguration.class})
@EnableConfigurationProperties(value={DingerProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.dinger", value={"enabled"}, havingValue="true")
public class DingtalkAutoConfiguration
implements InitializingBean {
    private final DingerProperties properties;
    private final ResourceLoader resourceLoader;

    public DingtalkAutoConfiguration(DingerProperties dingerProperties, ResourceLoader resourceLoader) {
        this.properties = dingerProperties;
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(DingtalkAutoConfiguration.class, (String)"taotao-cloud-starter-dingtalk", (String[])new String[0]);
        this.checkConfigFileExists();
    }

    @Bean
    @ConditionalOnMissingBean(value={DingerConfigurerAdapter.class})
    public DingerConfigurerAdapter dingerConfigurerAdapter() {
        return new DingerConfigurerAdapter();
    }

    @Bean
    public DingerManagerBuilder dingerManagerBuilder(@Autowired @Qualifier(value="dingerRestTemplate") RestTemplate restTemplate, DingerExceptionCallback dingerExceptionCallback, @Autowired @Qualifier(value="textMessage") CustomMessage textMessage, @Autowired @Qualifier(value="markDownMessage") CustomMessage markDownMessage, DingTalkSignAlgorithm dingerSignAlgorithm, DingerIdGenerator dingerIdGenerator, @Autowired @Qualifier(value="dingerExecutor") Executor dingTalkExecutor, DingerAsyncCallback dingerAsyncCallback, DingerHttpClient dingerHttpClient) {
        return new DingerManagerBuilder(restTemplate, dingerExceptionCallback, textMessage, markDownMessage, dingerSignAlgorithm, dingerIdGenerator, dingTalkExecutor, dingerAsyncCallback, dingerHttpClient);
    }

    @Bean
    public DingerSender dingerSender(DingerConfigurerAdapter dingerConfigurerAdapter, DingerManagerBuilder dingerManagerBuilder) {
        try {
            dingerConfigurerAdapter.configure(dingerManagerBuilder);
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
        return new DingerRobot(this.properties, dingerManagerBuilder);
    }

    @Bean
    @ConditionalOnMissingBean
    public DingerSessionFactory dingerSessionFactory(DingerRobot dingerRobot) throws Exception {
        DingerSessionFactoryBean factory = new DingerSessionFactoryBean();
        factory.setConfiguration(SessionConfiguration.of(this.properties, dingerRobot));
        return factory.getObject();
    }

    private void checkConfigFileExists() {
        if (StringUtils.hasText((String)this.properties.getDingerLocations())) {
            Resource resource = this.resourceLoader.getResource(this.properties.getDingerLocations());
            Assert.state((boolean)resource.exists(), (String)("Cannot find config location: " + resource + " (please add config file or check your Dinger configuration)"));
        }
    }
}

