/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dingtalk.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.dingtalk.properties.HttpClientProperties;
import com.taotao.cloud.dingtalk.support.DingerHttpClient;
import com.taotao.cloud.dingtalk.support.DingerHttpTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@EnableConfigurationProperties(value={HttpClientProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.dinger.httpclient", value={"enabled"}, havingValue="true")
public class HttpClientAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(HttpClientAutoConfiguration.class, (String)"taotao-cloud-starter-dingtalk", (String[])new String[0]);
    }

    @Bean(name={"dingerClientHttpRequestFactory"})
    public ClientHttpRequestFactory dingerClientHttpRequestFactory(HttpClientProperties httpClientProperties) {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout((int)httpClientProperties.getReadTimeout().toMillis());
        factory.setConnectTimeout((int)httpClientProperties.getConnectTimeout().toMillis());
        return factory;
    }

    @Bean(name={"dingerRestTemplate"})
    public RestTemplate restTemplate(ClientHttpRequestFactory dingerClientHttpRequestFactory) {
        return new RestTemplate(dingerClientHttpRequestFactory);
    }

    @Bean
    public DingerHttpClient dingerHttpClient(@Autowired @Qualifier(value="dingerRestTemplate") RestTemplate restTemplate) {
        return new DingerHttpTemplate(restTemplate);
    }
}

