/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dingtalk.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.dingtalk.properties.ThreadPoolProperties;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@AutoConfiguration
@EnableConfigurationProperties(value={ThreadPoolProperties.class})
@ConditionalOnMissingBean(name={"dingerExecutor"})
@ConditionalOnProperty(prefix="taotao.cloud.dinger.threadpool", name={"enabled"}, havingValue="true")
public class ThreadPoolAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(ThreadPoolAutoConfiguration.class, (String)"taotao-cloud-starter-dingtalk", (String[])new String[0]);
    }

    @Bean(name={"dingerExecutor"})
    public Executor dingTalkExecutor(ThreadPoolProperties threadPoolProperties) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(threadPoolProperties.getCoreSize());
        executor.setMaxPoolSize(threadPoolProperties.getMaxSize());
        executor.setKeepAliveSeconds(threadPoolProperties.getKeepAliveSeconds());
        executor.setQueueCapacity(threadPoolProperties.getQueueCapacity());
        executor.setThreadNamePrefix(threadPoolProperties.getThreadNamePrefix());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.initialize();
        return executor;
    }
}

