/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dingtalk.enums;

import com.taotao.cloud.dingtalk.entity.DingFeedCard;
import com.taotao.cloud.dingtalk.entity.DingLink;
import com.taotao.cloud.dingtalk.entity.DingMarkDown;
import com.taotao.cloud.dingtalk.entity.DingText;
import com.taotao.cloud.dingtalk.entity.DingerRequest;
import com.taotao.cloud.dingtalk.entity.Message;
import com.taotao.cloud.dingtalk.entity.MsgType;
import com.taotao.cloud.dingtalk.entity.WeMarkdown;
import com.taotao.cloud.dingtalk.entity.WeNews;
import com.taotao.cloud.dingtalk.entity.WeText;
import com.taotao.cloud.dingtalk.enums.DingerType;
import com.taotao.cloud.dingtalk.enums.ExceptionEnum;
import com.taotao.cloud.dingtalk.exception.DingerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MessageSubType {
    TEXT(true){

        @Override
        public MsgType msgType(DingerType dingerType, DingerRequest request) {
            String content = request.getContent();
            boolean atAll = request.isAtAll();
            List<String> phones = request.getPhones();
            if (dingerType == DingerType.DINGTALK) {
                DingText message = new DingText(new DingText.Text(content));
                if (atAll) {
                    message.setAt(new Message.At(true));
                } else if (phones != null && !phones.isEmpty()) {
                    message.setAt(new Message.At(phones));
                }
                return message;
            }
            WeText.Text text = new WeText.Text(content);
            WeText weText = new WeText(text);
            if (atAll) {
                text.setMentioned_mobile_list(List.of("@all"));
            } else if (phones != null && !phones.isEmpty()) {
                text.setMentioned_mobile_list(phones);
            }
            return weText;
        }
    }
    ,
    MARKDOWN(true){

        @Override
        public MsgType msgType(DingerType dingerType, DingerRequest request) {
            String content = request.getContent();
            String title = request.getTitle();
            List<String> phones = request.getPhones();
            if (dingerType == DingerType.DINGTALK) {
                DingMarkDown message = new DingMarkDown(new DingMarkDown.MarkDown(title, content));
                if (!phones.isEmpty()) {
                    message.setAt(new Message.At(phones));
                }
                return message;
            }
            WeMarkdown.Markdown markdown = new WeMarkdown.Markdown(content);
            WeMarkdown weMarkdown = new WeMarkdown(markdown);
            return weMarkdown;
        }
    }
    ,
    IMAGETEXT(false){

        @Override
        public MsgType msgType(DingerType dingerType, DingerRequest request) {
            if (dingerType == DingerType.DINGTALK) {
                return new DingFeedCard(new ArrayList<DingFeedCard.FeedCard.Link>());
            }
            return new WeNews(new ArrayList<WeNews.News.Article>());
        }
    }
    ,
    LINK(false){

        @Override
        public MsgType msgType(DingerType dingerType, DingerRequest request) {
            if (dingerType == DingerType.DINGTALK) {
                return new DingLink();
            }
            throw new DingerException(ExceptionEnum.DINGER_UNSUPPORT_MESSAGE_TYPE_EXCEPTION, new Object[]{dingerType, this.name()});
        }
    };

    private boolean support;

    private MessageSubType(boolean support) {
        this.support = support;
    }

    public boolean isSupport() {
        return this.support;
    }

    public abstract MsgType msgType(DingerType var1, DingerRequest var2);

    public static boolean contains(String value) {
        return Arrays.stream(MessageSubType.values()).filter(e -> Objects.equals(e.name(), value)).count() > 0L;
    }
}

