/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dingtalk.model;

import com.taotao.cloud.dingtalk.entity.DingerCallback;
import com.taotao.cloud.dingtalk.enums.MessageSubType;
import com.taotao.cloud.dingtalk.exception.DingerException;
import com.taotao.cloud.dingtalk.model.DingerHelper;
import com.taotao.cloud.dingtalk.model.DingerManagerBuilder;
import com.taotao.cloud.dingtalk.model.DingerSender;
import com.taotao.cloud.dingtalk.properties.DingerProperties;
import com.taotao.cloud.dingtalk.support.CustomMessage;

public abstract class AbstractDingerSender
extends DingerHelper
implements DingerSender {
    protected DingerProperties dingerProperties;
    protected DingerManagerBuilder dingTalkManagerBuilder;

    public AbstractDingerSender(DingerProperties dingerProperties, DingerManagerBuilder dingTalkManagerBuilder) {
        this.dingerProperties = dingerProperties;
        this.dingTalkManagerBuilder = dingTalkManagerBuilder;
    }

    protected CustomMessage customMessage(MessageSubType messageSubType) {
        return messageSubType == MessageSubType.TEXT ? this.dingTalkManagerBuilder.getTextMessage() : this.dingTalkManagerBuilder.getMarkDownMessage();
    }

    protected <T> void exceptionCallback(String dingerId, T message, DingerException ex) {
        DingerCallback<T> dkExCallable = new DingerCallback<T>(dingerId, message, ex);
        this.dingTalkManagerBuilder.getDingerExceptionCallback().execute(dkExCallable);
    }
}

