/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dingtalk.model;

import com.taotao.cloud.dingtalk.annatations.DingerClose;
import com.taotao.cloud.dingtalk.entity.DingerResponse;
import com.taotao.cloud.dingtalk.entity.MsgType;
import com.taotao.cloud.dingtalk.enums.DingerResponseCodeEnum;
import com.taotao.cloud.dingtalk.enums.DingerType;
import com.taotao.cloud.dingtalk.enums.IgnoreMethod;
import com.taotao.cloud.dingtalk.model.DingerDefinition;
import com.taotao.cloud.dingtalk.model.DingerHelper;
import com.taotao.cloud.dingtalk.model.DingerInvocationHandler;
import com.taotao.cloud.dingtalk.session.SessionConfiguration;
import java.lang.reflect.Method;
import java.util.Map;

public class DingerHandleProxy
extends DingerInvocationHandler {
    public DingerHandleProxy(SessionConfiguration sessionConfiguration) {
        this.dingerRobot = sessionConfiguration.getDingerRobot();
        this.dingerProperties = sessionConfiguration.getDingerProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> dingerClass = method.getDeclaringClass();
        String methodName = method.getName();
        if (ignoreMethodMap.containsKey(methodName)) {
            return ((IgnoreMethod)((Object)ignoreMethodMap.get(methodName))).execute(this, args);
        }
        if (dingerClass.isAnnotationPresent(DingerClose.class)) {
            return null;
        }
        if (method.isAnnotationPresent(DingerClose.class)) {
            return null;
        }
        String dingerClassName = dingerClass.getName();
        String keyName = dingerClassName + "." + methodName;
        try {
            DingerResponse dingerResponse;
            DingerType useDinger = this.dingerType(method);
            DingerDefinition dingerDefinition = this.dingerDefinition(useDinger, dingerClassName, keyName);
            if (dingerDefinition == null) {
                dingerResponse = DingerResponse.failed(DingerResponseCodeEnum.MESSAGE_TYPE_UNSUPPORTED, String.format("method %s does not support dinger %s.", new Object[]{keyName, useDinger}));
            } else {
                Map<String, Object> params = this.paramsHandler(method, dingerDefinition, args);
                MsgType message = this.transfer(dingerDefinition, params);
                dingerResponse = this.dingerRobot.send(message);
            }
            Object object = this.resultHandler(method.getReturnType(), dingerResponse);
            return object;
        }
        finally {
            DingerHelper.clearDinger();
        }
    }
}

