/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dingtalk.model;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.dingtalk.annatations.Dinger;
import com.taotao.cloud.dingtalk.annatations.Parameter;
import com.taotao.cloud.dingtalk.entity.DingerResponse;
import com.taotao.cloud.dingtalk.entity.MsgType;
import com.taotao.cloud.dingtalk.entity.MultiDingerConfig;
import com.taotao.cloud.dingtalk.enums.DingerType;
import com.taotao.cloud.dingtalk.enums.MultiDingerConfigContainer;
import com.taotao.cloud.dingtalk.model.AbstractDingerDefinitionResolver;
import com.taotao.cloud.dingtalk.model.DingerConfig;
import com.taotao.cloud.dingtalk.model.DingerDefinition;
import com.taotao.cloud.dingtalk.model.DingerHelper;
import com.taotao.cloud.dingtalk.model.DingerRobot;
import com.taotao.cloud.dingtalk.model.MessageTransfer;
import com.taotao.cloud.dingtalk.model.ParamHandler;
import com.taotao.cloud.dingtalk.model.ResultHandler;
import com.taotao.cloud.dingtalk.multi.MultiDingerProperty;
import com.taotao.cloud.dingtalk.properties.DingerProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DingerMessageHandler
extends MultiDingerProperty
implements ParamHandler,
MessageTransfer,
ResultHandler<DingerResponse> {
    protected DingerRobot dingerRobot;
    protected DingerProperties dingerProperties;

    @Override
    public Map<String, Object> paramsHandler(Method method, DingerDefinition dingerDefinition, Object[] values) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        int valueLength = values.length;
        if (valueLength == 0) {
            return params;
        }
        String[] keys = dingerDefinition.methodParams();
        int[] genericIndex = dingerDefinition.genericIndex();
        if (genericIndex.length > 0) {
            for (int i : genericIndex) {
                params.put(keys[i], values[i]);
            }
            return params;
        }
        int keyLength = keys.length;
        if (keyLength == valueLength) {
            for (int i = 0; i < valueLength; ++i) {
                params.put(keys[i], values[i]);
            }
            return params;
        }
        java.lang.reflect.Parameter[] parameters = method.getParameters();
        for (int i = 0; i < Objects.requireNonNull(parameters).length; ++i) {
            java.lang.reflect.Parameter parameter = parameters[i];
            String paramName = parameter.getName();
            Parameter[] panno = (Parameter[])parameter.getDeclaredAnnotationsByType(Parameter.class);
            if (panno != null && panno.length > 0) {
                paramName = panno[0].value();
            }
            params.put(paramName, values[i]);
        }
        return params;
    }

    @Override
    public MsgType transfer(DingerDefinition dingerDefinition, Map<String, Object> params) {
        Object message = this.copyProperties(dingerDefinition.message());
        ((MsgType)message).transfer(params);
        return message;
    }

    @Override
    public Object resultHandler(Class<?> resultType, DingerResponse dingerResponse) {
        String name = resultType.getName();
        if (String.class.getName().equals(name)) {
            return Optional.ofNullable(dingerResponse).map(e -> e.getData()).orElse(null);
        }
        if (DingerResponse.class.getName().equals(name)) {
            return dingerResponse;
        }
        return null;
    }

    private <T extends MsgType> T copyProperties(MsgType src) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(src);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            MsgType dest = (MsgType)in.readObject();
            return (T)dest;
        }
        catch (Exception e) {
            LogUtils.debug((String)"copy properties error:", (Object[])new Object[]{e});
            return null;
        }
    }

    DingerType dingerType(Method method) {
        Class<?> dingerClass = method.getDeclaringClass();
        if (dingerClass.isAnnotationPresent(Dinger.class)) {
            return dingerClass.getAnnotation(Dinger.class).value();
        }
        return this.dingerProperties.getDefaultDinger();
    }

    DingerDefinition dingerDefinition(DingerType useDinger, String dingerClassName, String keyName) {
        DingerDefinition dingerDefinition;
        DingerConfig localDinger = DingerHelper.getLocalDinger();
        if (localDinger == null) {
            String dingerName = useDinger + "." + (String)keyName;
            dingerDefinition = AbstractDingerDefinitionResolver.Container.INSTANCE.get(dingerName);
            if (dingerDefinition == null) {
                return null;
            }
            DingerConfig dingerMethodDefaultDingerConfig = dingerDefinition.dingerConfig();
            if (DingerMessageHandler.multiDinger()) {
                MultiDingerConfig multiDingerConfig = MultiDingerConfigContainer.INSTANCE.get(useDinger, dingerClassName);
                DingerConfig dingerConfig = null;
                if (multiDingerConfig != null) {
                    dingerConfig = multiDingerConfig.getAlgorithmHandler().dingerConfig(multiDingerConfig.getDingerConfigs(), dingerMethodDefaultDingerConfig);
                }
                if (dingerConfig == null) {
                    dingerConfig = dingerMethodDefaultDingerConfig;
                }
                DingerHelper.assignDinger(dingerConfig);
            } else {
                DingerHelper.assignDinger(dingerMethodDefaultDingerConfig);
            }
        } else {
            DingerType dingerType = localDinger.getDingerType();
            if (dingerType == null) {
                dingerType = useDinger;
            }
            if ((dingerDefinition = AbstractDingerDefinitionResolver.Container.INSTANCE.get((String)(keyName = dingerType + "." + (String)keyName))) == null) {
                return null;
            }
        }
        return dingerDefinition;
    }
}

