/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dingtalk.model;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.dingtalk.entity.DingerRequest;
import com.taotao.cloud.dingtalk.entity.DingerResponse;
import com.taotao.cloud.dingtalk.entity.MsgType;
import com.taotao.cloud.dingtalk.enums.DingerResponseCodeEnum;
import com.taotao.cloud.dingtalk.enums.DingerType;
import com.taotao.cloud.dingtalk.enums.MediaTypeEnum;
import com.taotao.cloud.dingtalk.enums.MessageSubType;
import com.taotao.cloud.dingtalk.exception.AsyncCallException;
import com.taotao.cloud.dingtalk.exception.SendMsgException;
import com.taotao.cloud.dingtalk.model.AbstractDingerSender;
import com.taotao.cloud.dingtalk.model.DingerConfig;
import com.taotao.cloud.dingtalk.model.DingerManagerBuilder;
import com.taotao.cloud.dingtalk.properties.DingerProperties;
import com.taotao.cloud.dingtalk.support.CustomMessage;
import com.taotao.cloud.dingtalk.support.SignBase;
import com.taotao.cloud.dingtalk.utils.DingerUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public class DingerRobot
extends AbstractDingerSender {
    public DingerRobot(DingerProperties dingerProperties, DingerManagerBuilder dingTalkManagerBuilder) {
        super(dingerProperties, dingTalkManagerBuilder);
    }

    @Override
    public DingerResponse send(MessageSubType messageSubType, DingerRequest request) {
        return this.send(this.dingerProperties.getDefaultDinger(), messageSubType, request);
    }

    @Override
    public DingerResponse send(DingerType dingerType, MessageSubType messageSubType, DingerRequest request) {
        if (!messageSubType.isSupport()) {
            return DingerResponse.failed(DingerResponseCodeEnum.MESSAGE_TYPE_UNSUPPORTED);
        }
        CustomMessage customMessage = this.customMessage(messageSubType);
        String msgContent = customMessage.message(this.dingerProperties.getProjectId(), request);
        request.setContent(msgContent);
        MsgType msgType = messageSubType.msgType(dingerType, request);
        return this.send(msgType);
    }

    protected <T extends MsgType> DingerResponse send(T message) {
        DingerType dingerType = message.getDingerType();
        String dkid = this.dingTalkManagerBuilder.getDingerIdGenerator().dingerId();
        Map<DingerType, DingerProperties.Dinger> dingers = this.dingerProperties.getDingers();
        if (!this.dingerProperties.getEnabled() || !dingers.containsKey((Object)dingerType)) {
            return DingerResponse.failed(dkid, DingerResponseCodeEnum.DINGER_DISABLED);
        }
        DingerConfig localDinger = DingerRobot.getLocalDinger();
        boolean dingerConfig = localDinger != null;
        try {
            DingerProperties.Dinger dinger;
            if (dingerConfig) {
                dinger = new DingerProperties.Dinger();
                BeanUtils.copyProperties((Object)localDinger, (Object)dinger);
                dinger.setAsync(localDinger.getAsyncExecute());
                dinger.setRobotUrl(dingers.get((Object)dingerType).getRobotUrl());
            } else {
                dinger = dingers.get((Object)dingerType);
            }
            StringBuilder webhook = new StringBuilder();
            webhook.append(dinger.getRobotUrl()).append("=").append(dinger.getTokenId());
            LogUtils.info((String)"dingerId={} send message and use dinger={}, tokenId={}.", (Object[])new Object[]{dkid, dingerType, dinger.getTokenId()});
            if (dingerType == DingerType.DINGTALK && DingerUtils.isNotEmpty(dinger.getSecret())) {
                Object sign = this.dingTalkManagerBuilder.getDingerSignAlgorithm().sign(dinger.getSecret().trim());
                webhook.append(((SignBase)sign).transfer());
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", MediaTypeEnum.JSON.type());
            if (dinger.isAsync()) {
                this.dingTalkManagerBuilder.getDingTalkExecutor().execute(() -> {
                    try {
                        String result = this.dingTalkManagerBuilder.getDingerHttpClient().post(webhook.toString(), (Map<String, String>)headers, message);
                        this.dingTalkManagerBuilder.getDingerAsyncCallback().execute(dkid, result);
                    }
                    catch (Exception e) {
                        this.exceptionCallback(dkid, message, new AsyncCallException(e));
                    }
                });
                return DingerResponse.success(dkid, dkid);
            }
            String response = this.dingTalkManagerBuilder.getDingerHttpClient().post(webhook.toString(), headers, message);
            LogUtils.info((String)response, (Object[])new Object[0]);
            return DingerResponse.success(dkid, response);
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            this.exceptionCallback(dkid, message, new SendMsgException(e));
            return DingerResponse.failed(dkid, DingerResponseCodeEnum.SEND_MESSAGE_FAILED);
        }
    }
}

