/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dingtalk.properties;

import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.dingtalk.enums.DingerType;
import com.taotao.cloud.dingtalk.exception.InvalidPropertiesFormatException;
import com.taotao.cloud.dingtalk.utils.ConfigTools;
import com.taotao.cloud.dingtalk.utils.DingerUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@RefreshScope
@ConfigurationProperties(prefix="taotao.cloud.dinger")
public class DingerProperties
implements InitializingBean {
    public static final String PREFIX = "taotao.cloud.dinger";
    private boolean enabled = false;
    private Map<DingerType, Dinger> dingers = new LinkedHashMap<DingerType, Dinger>();
    private String projectId;
    private String dingerLocations;
    private DingerType defaultDinger;

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<DingerType, Dinger> getDingers() {
        return this.dingers;
    }

    public void setDingers(Map<DingerType, Dinger> dingers) {
        this.dingers = dingers;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getDingerLocations() {
        return this.dingerLocations;
    }

    public void setDingerLocations(String dingerLocations) {
        this.dingerLocations = dingerLocations;
    }

    public DingerType getDefaultDinger() {
        return this.defaultDinger;
    }

    public void setDefaultDinger(DingerType defaultDinger) {
        this.defaultDinger = defaultDinger;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dingers.isEmpty()) {
            throw new InvalidPropertiesFormatException("spring.dinger.dingers is empty.");
        }
        for (Map.Entry<DingerType, Dinger> entry : this.dingers.entrySet()) {
            boolean check;
            DingerType dingerType = entry.getKey();
            if (!dingerType.isEnabled()) {
                throw new InvalidPropertiesFormatException(String.format("dinger=%s is disabled", new Object[]{dingerType}));
            }
            Dinger dinger = entry.getValue();
            String tokenId = dinger.getTokenId();
            if (StringUtils.isEmpty((String)tokenId)) {
                throw new InvalidPropertiesFormatException("spring.dinger.token-id is empty.");
            }
            if (DingerUtils.isEmpty(dinger.robotUrl)) {
                dinger.robotUrl = dingerType.getRobotUrl();
            }
            if (dingerType == DingerType.WETALK) {
                dinger.secret = null;
            }
            boolean bl = check = dinger.decrypt && StringUtils.isEmpty((String)dinger.decryptKey);
            if (check) {
                throw new InvalidPropertiesFormatException("spring.dinger.decrypt is true but spring.dinger.decrypt-key is empty.");
            }
            if (dinger.decrypt) {
                dinger.tokenId = ConfigTools.decrypt(dinger.decryptKey, dinger.tokenId);
            } else {
                dinger.decryptKey = null;
            }
            if (this.defaultDinger != null) continue;
            this.defaultDinger = dingerType;
            LogUtils.debug((String)"defaultDinger undeclared and use first dingers dingerType, defaultDinger={}.", (Object[])new Object[]{this.defaultDinger});
        }
        if (!this.defaultDinger.isEnabled()) {
            throw new InvalidPropertiesFormatException("spring.dinger.default-dinger is disabled.");
        }
        if (DingerUtils.isEmpty(this.projectId)) {
            throw new InvalidPropertiesFormatException("spring.dinger.project-id is empty.");
        }
    }

    public static class Dinger {
        private String robotUrl;
        private String tokenId;
        private String secret;
        private boolean decrypt = false;
        private String decryptKey;
        private boolean async = false;

        public String getRobotUrl() {
            return this.robotUrl;
        }

        public void setRobotUrl(String robotUrl) {
            this.robotUrl = robotUrl;
        }

        public String getTokenId() {
            return this.tokenId;
        }

        public void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public boolean isDecrypt() {
            return this.decrypt;
        }

        public void setDecrypt(boolean decrypt) {
            this.decrypt = decrypt;
        }

        public String getDecryptKey() {
            return this.decryptKey;
        }

        public void setDecryptKey(String decryptKey) {
            this.decryptKey = decryptKey;
        }

        public boolean isAsync() {
            return this.async;
        }

        public void setAsync(boolean async) {
            this.async = async;
        }
    }
}

