/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.disruptor.configuration;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.EventTranslatorThreeArg;
import com.lmax.disruptor.EventTranslatorTwoArg;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.EventHandlerGroup;
import com.lmax.disruptor.dsl.ProducerType;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.disruptor.annotation.EventRule;
import com.taotao.cloud.disruptor.context.DisruptorEventAwareProcessor;
import com.taotao.cloud.disruptor.context.DisruptorTemplate;
import com.taotao.cloud.disruptor.context.EventHandlerDefinition;
import com.taotao.cloud.disruptor.context.Ini;
import com.taotao.cloud.disruptor.event.DisruptorApplicationEvent;
import com.taotao.cloud.disruptor.event.DisruptorBindEventFactory;
import com.taotao.cloud.disruptor.event.DisruptorEvent;
import com.taotao.cloud.disruptor.event.DisruptorEventThreadFactory;
import com.taotao.cloud.disruptor.handler.DefaultHandlerChainManager;
import com.taotao.cloud.disruptor.handler.DisruptorEventDispatcher;
import com.taotao.cloud.disruptor.handler.DisruptorHandler;
import com.taotao.cloud.disruptor.handler.HandlerChainManager;
import com.taotao.cloud.disruptor.handler.Nameable;
import com.taotao.cloud.disruptor.handler.PathMatchingHandlerChainResolver;
import com.taotao.cloud.disruptor.hooks.DisruptorShutdownHook;
import com.taotao.cloud.disruptor.properties.DisruptorProperties;
import com.taotao.cloud.disruptor.translator.DisruptorEventOneArgTranslator;
import com.taotao.cloud.disruptor.translator.DisruptorEventThreeArgTranslator;
import com.taotao.cloud.disruptor.translator.DisruptorEventTwoArgTranslator;
import com.taotao.cloud.disruptor.util.StringUtils;
import com.taotao.cloud.disruptor.util.WaitStrategys;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.core.OrderComparator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@AutoConfiguration
@ConditionalOnClass(value={Disruptor.class})
@EnableConfigurationProperties(value={DisruptorProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.disruptor", value={"enabled"}, havingValue="true")
public class DisruptorAutoConfiguration
implements ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private final Map<String, String> handlerChainDefinitionMap = new HashMap<String, String>();

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(DisruptorAutoConfiguration.class, (String)"taotao-cloud-starter-disruptor", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnMissingBean
    public WaitStrategy waitStrategy() {
        return WaitStrategys.YIELDING_WAIT;
    }

    @Bean
    @ConditionalOnMissingBean
    public EventFactory<DisruptorEvent> eventFactory() {
        return new DisruptorBindEventFactory();
    }

    @Bean(value={"disruptorHandlers"})
    public Map<String, DisruptorHandler<DisruptorEvent>> disruptorHandlers() {
        LinkedHashMap<String, DisruptorHandler<DisruptorEvent>> disruptorPreHandlers = new LinkedHashMap<String, DisruptorHandler<DisruptorEvent>>();
        Map beansOfType = this.getApplicationContext().getBeansOfType(DisruptorHandler.class);
        if (!ObjectUtils.isEmpty((Object)beansOfType)) {
            for (Map.Entry entry : beansOfType.entrySet()) {
                if (entry.getValue() instanceof DisruptorEventDispatcher) continue;
                EventRule annotationType = (EventRule)this.getApplicationContext().findAnnotationOnBean((String)entry.getKey(), EventRule.class);
                if (annotationType == null) {
                    LogUtils.error((String)"Not Found AnnotationType {} on Bean {} Whith Name {}", (Object[])new Object[]{EventRule.class, ((DisruptorHandler)entry.getValue()).getClass(), entry.getKey()});
                } else {
                    this.handlerChainDefinitionMap.put(annotationType.value(), (String)entry.getKey());
                }
                disruptorPreHandlers.put((String)entry.getKey(), (DisruptorHandler)entry.getValue());
            }
        }
        return disruptorPreHandlers;
    }

    @Bean(value={"disruptorEventHandlers"})
    public List<DisruptorEventDispatcher> disruptorEventHandlers(DisruptorProperties properties, @Qualifier(value="disruptorHandlers") Map<String, DisruptorHandler<DisruptorEvent>> eventHandlers) {
        List<EventHandlerDefinition> handlerDefinitions = properties.getHandlerDefinitions();
        ArrayList<DisruptorEventDispatcher> disruptorEventHandlers = new ArrayList<DisruptorEventDispatcher>();
        if (CollectionUtils.isEmpty(handlerDefinitions)) {
            EventHandlerDefinition definition = new EventHandlerDefinition();
            definition.setOrder(0);
            definition.setDefinitionMap(this.handlerChainDefinitionMap);
            disruptorEventHandlers.add(this.createDisruptorEventHandler(definition, eventHandlers));
        } else {
            for (EventHandlerDefinition handlerDefinition : handlerDefinitions) {
                disruptorEventHandlers.add(this.createDisruptorEventHandler(handlerDefinition, eventHandlers));
            }
        }
        disruptorEventHandlers.sort((Comparator<DisruptorEventDispatcher>)new OrderComparator());
        return disruptorEventHandlers;
    }

    protected DisruptorEventDispatcher createDisruptorEventHandler(EventHandlerDefinition handlerDefinition, Map<String, DisruptorHandler<DisruptorEvent>> eventHandlers) {
        if (StringUtils.isNotEmpty(handlerDefinition.getDefinitions())) {
            this.handlerChainDefinitionMap.putAll(this.parseHandlerChainDefinitions(handlerDefinition.getDefinitions()));
        } else if (!CollectionUtils.isEmpty(handlerDefinition.getDefinitionMap())) {
            this.handlerChainDefinitionMap.putAll(handlerDefinition.getDefinitionMap());
        }
        HandlerChainManager<DisruptorEvent> manager = this.createHandlerChainManager(eventHandlers, this.handlerChainDefinitionMap);
        PathMatchingHandlerChainResolver chainResolver = new PathMatchingHandlerChainResolver();
        chainResolver.setHandlerChainManager(manager);
        return new DisruptorEventDispatcher(chainResolver, handlerDefinition.getOrder());
    }

    protected Map<String, String> parseHandlerChainDefinitions(String definitions) {
        Ini ini = new Ini();
        ini.load(definitions);
        Ini.Section section = ini.getSection("urls");
        if (CollectionUtils.isEmpty((Map)section)) {
            section = ini.getSection("");
        }
        return section;
    }

    protected HandlerChainManager<DisruptorEvent> createHandlerChainManager(Map<String, DisruptorHandler<DisruptorEvent>> eventHandlers, Map<String, String> handlerChainDefinitionMap) {
        DefaultHandlerChainManager manager = new DefaultHandlerChainManager();
        if (!CollectionUtils.isEmpty(eventHandlers)) {
            for (Map.Entry<String, Object> entry : eventHandlers.entrySet()) {
                String name = entry.getKey();
                DisruptorHandler handler = (DisruptorHandler)entry.getValue();
                if (handler instanceof Nameable) {
                    ((Nameable)((Object)handler)).setName(name);
                }
                manager.addHandler(name, handler);
            }
        }
        if (!CollectionUtils.isEmpty(handlerChainDefinitionMap)) {
            for (Map.Entry<String, Object> entry : handlerChainDefinitionMap.entrySet()) {
                String rule = entry.getKey();
                String chainDefinition = (String)entry.getValue();
                manager.createChain(rule, chainDefinition);
            }
        }
        return manager;
    }

    @Bean
    @ConditionalOnClass(value={Disruptor.class})
    @ConditionalOnProperty(prefix="taotao.cloud.disruptor", value={"enabled"}, havingValue="true")
    public Disruptor<DisruptorEvent> disruptor(DisruptorProperties properties, WaitStrategy waitStrategy, EventFactory<DisruptorEvent> eventFactory, @Qualifier(value="disruptorEventHandlers") List<DisruptorEventDispatcher> disruptorEventHandlers) {
        DisruptorEventThreadFactory threadFactory = new DisruptorEventThreadFactory();
        Disruptor disruptor = properties.getMultiProducer() ? new Disruptor(eventFactory, properties.getRingBufferSize(), (ThreadFactory)threadFactory, ProducerType.MULTI, waitStrategy) : new Disruptor(eventFactory, properties.getRingBufferSize(), (ThreadFactory)threadFactory, ProducerType.SINGLE, waitStrategy);
        if (!ObjectUtils.isEmpty(disruptorEventHandlers)) {
            disruptorEventHandlers.sort((Comparator<DisruptorEventDispatcher>)new OrderComparator());
            EventHandlerGroup handlerGroup = null;
            for (int i = 0; i < disruptorEventHandlers.size(); ++i) {
                DisruptorEventDispatcher eventHandler = disruptorEventHandlers.get(i);
                if (i < 1) {
                    handlerGroup = disruptor.handleEventsWith(new EventHandler[]{eventHandler});
                    continue;
                }
                handlerGroup.then(new EventHandler[]{eventHandler});
            }
        }
        disruptor.start();
        Runtime.getRuntime().addShutdownHook(new DisruptorShutdownHook((Disruptor<DisruptorEvent>)disruptor));
        return disruptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public EventTranslatorOneArg<DisruptorEvent, DisruptorEvent> oneArgEventTranslator() {
        return new DisruptorEventOneArgTranslator();
    }

    @Bean
    @ConditionalOnMissingBean
    public EventTranslatorTwoArg<DisruptorEvent, String, String> twoArgEventTranslator() {
        return new DisruptorEventTwoArgTranslator();
    }

    @Bean
    @ConditionalOnMissingBean
    public EventTranslatorThreeArg<DisruptorEvent, String, String, String> threeArgEventTranslator() {
        return new DisruptorEventThreeArgTranslator();
    }

    @Bean
    public DisruptorTemplate disruptorTemplate(Disruptor<DisruptorEvent> disruptor, EventTranslatorOneArg<DisruptorEvent, DisruptorEvent> oneArgEventTranslator) {
        return new DisruptorTemplate(disruptor, oneArgEventTranslator);
    }

    @Bean
    public ApplicationListener<DisruptorApplicationEvent> disruptorEventListener(Disruptor<DisruptorEvent> disruptor, EventTranslatorOneArg<DisruptorEvent, DisruptorEvent> oneArgEventTranslator) {
        return appEvent -> {
            DisruptorEvent event = (DisruptorEvent)appEvent.getSource();
            disruptor.publishEvent(oneArgEventTranslator, (Object)event);
        };
    }

    @Bean
    public DisruptorEventAwareProcessor disruptorEventAwareProcessor() {
        return new DisruptorEventAwareProcessor();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

