/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.disruptor.configuration;

import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.DataProvider;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.disruptor.event.DisruptorEvent;
import com.taotao.cloud.disruptor.handler.DisruptorEventDispatcher;
import com.taotao.cloud.disruptor.properties.DisruptorProperties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={Disruptor.class})
@ConditionalOnProperty(prefix="taotao.cloud.disruptor", value={"enabled"}, havingValue="true")
public class RingBufferAutoConfiguration
implements ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(RingBufferAutoConfiguration.class, (String)"taotao-cloud-starter-disruptor", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnClass(value={RingBuffer.class})
    @ConditionalOnProperty(prefix="taotao.cloud.disruptor", value={"ring-buffer"}, havingValue="true")
    public RingBuffer<DisruptorEvent> ringBuffer(DisruptorProperties properties, WaitStrategy waitStrategy, EventFactory<DisruptorEvent> eventFactory, @Autowired(required=false) DisruptorEventDispatcher preEventHandler, @Autowired(required=false) DisruptorEventDispatcher postEventHandler) {
        ExecutorService executor = Executors.newFixedThreadPool(properties.getRingThreadNumbers());
        RingBuffer ringBuffer = properties.getMultiProducer() ? RingBuffer.createMultiProducer(eventFactory, (int)properties.getRingBufferSize(), (WaitStrategy)waitStrategy) : RingBuffer.createSingleProducer(eventFactory, (int)properties.getRingBufferSize(), (WaitStrategy)waitStrategy);
        if (null != preEventHandler) {
            SequenceBarrier sequenceBarrier = ringBuffer.newBarrier(new Sequence[0]);
            BatchEventProcessor transProcessor = new BatchEventProcessor((DataProvider)ringBuffer, sequenceBarrier, (EventHandler)preEventHandler);
            ringBuffer.addGatingSequences(new Sequence[]{transProcessor.getSequence()});
            executor.submit((Runnable)transProcessor);
        }
        return ringBuffer;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

