/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.disruptor.context;

import com.taotao.cloud.disruptor.context.DisruptorEventPublisher;
import com.taotao.cloud.disruptor.context.DisruptorEventPublisherAware;
import com.taotao.cloud.disruptor.event.DisruptorEvent;
import java.lang.reflect.Constructor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.InitializingBean;

public class EventPublicationInterceptor
implements MethodInterceptor,
DisruptorEventPublisherAware,
InitializingBean {
    private Constructor<?> applicationEventClassConstructor;
    private DisruptorEventPublisher applicationEventPublisher;

    public void setApplicationEventClass(Class<?> applicationEventClass) {
        if (DisruptorEvent.class == applicationEventClass || !DisruptorEvent.class.isAssignableFrom(applicationEventClass)) {
            throw new IllegalArgumentException("applicationEventClass needs to extend DisruptorEvent");
        }
        try {
            this.applicationEventClassConstructor = applicationEventClass.getConstructor(Object.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("applicationEventClass [" + applicationEventClass.getName() + "] does not have the required Object constructor: " + ex);
        }
    }

    @Override
    public void setDisruptorEventPublisher(DisruptorEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.applicationEventClassConstructor == null) {
            throw new IllegalArgumentException("applicationEventClass is required");
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object retVal = invocation.proceed();
        DisruptorEvent event = (DisruptorEvent)this.applicationEventClassConstructor.newInstance(invocation.getThis());
        this.applicationEventPublisher.publishEvent(event);
        return retVal;
    }
}

