/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.disruptor.disruptor.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class DisruptorThreadFactory
implements ThreadFactory {
    private static final AtomicLong THREAD_NUMBER = new AtomicLong(1L);
    private static final ThreadGroup THREAD_GROUP = new ThreadGroup("taotao-cloud-disruptor");
    private final boolean daemon;
    private final String namePrefix;
    private final int priority;

    private DisruptorThreadFactory(String namePrefix, boolean daemon, int priority) {
        this.namePrefix = namePrefix;
        this.daemon = daemon;
        this.priority = priority;
    }

    public static ThreadFactory create(String namePrefix, boolean daemon) {
        return DisruptorThreadFactory.create(namePrefix, daemon, 5);
    }

    public static ThreadFactory create(String namePrefix, boolean daemon, int priority) {
        return new DisruptorThreadFactory(namePrefix, daemon, priority);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(THREAD_GROUP, runnable, THREAD_GROUP.getName() + "-" + this.namePrefix + "-" + THREAD_NUMBER.getAndIncrement());
        thread.setDaemon(this.daemon);
        thread.setPriority(this.priority);
        return thread;
    }
}

