/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.disruptor.handler;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.disruptor.event.DisruptorEvent;
import com.taotao.cloud.disruptor.handler.AbstractNameableEventHandler;
import com.taotao.cloud.disruptor.handler.HandlerChain;

public abstract class AbstractEnabledEventHandler<T extends DisruptorEvent>
extends AbstractNameableEventHandler<T> {
    protected boolean enabled = true;

    protected abstract void doHandlerInternal(T var1, HandlerChain<T> var2) throws Exception;

    @Override
    public void doHandler(T event, HandlerChain<T> handlerChain) throws Exception {
        if (!this.isEnabled(event)) {
            LogUtils.debug((String)"Handler '{}' is not enabled for the current event.  Proceeding without invoking this handler.", (Object[])new Object[]{this.getName()});
            handlerChain.doHandler(event);
        } else {
            LogUtils.info((String)"Handler '{}' enabled.  Executing now.", (Object[])new Object[]{this.getName()});
            this.doHandlerInternal(event, handlerChain);
        }
    }

    protected boolean isEnabled(T event) throws Exception {
        return this.isEnabled();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

